/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.AttributeEvent;

public class SetPrimaryKeyToModel
extends AbstractToModelToken.Entity {
    private Collection<DbAttribute> primaryKeyOriginal;
    private Collection<DbAttribute> primaryKeyNew;
    private String detectedPrimaryKeyName;
    private Set<String> primaryKeyNewAttributeNames = new HashSet<String>();

    public SetPrimaryKeyToModel(DbEntity entity, Collection<DbAttribute> primaryKeyOriginal, Collection<DbAttribute> primaryKeyNew, String detectedPrimaryKeyName) {
        super("Set Primary Key", 105, entity);
        this.primaryKeyOriginal = primaryKeyOriginal;
        this.primaryKeyNew = primaryKeyNew;
        this.detectedPrimaryKeyName = detectedPrimaryKeyName;
        for (DbAttribute attr : primaryKeyNew) {
            this.primaryKeyNewAttributeNames.add(attr.getName().toUpperCase());
        }
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createSetPrimaryKeyToDb(this.getEntity(), this.primaryKeyNew, this.primaryKeyOriginal, this.detectedPrimaryKeyName);
    }

    @Override
    public void execute(MergerContext mergerContext) {
        DbEntity e = this.getEntity();
        for (DbAttribute attr : e.getAttributes()) {
            boolean willBePrimaryKey;
            boolean wasPrimaryKey = attr.isPrimaryKey();
            if (wasPrimaryKey == (willBePrimaryKey = this.primaryKeyNewAttributeNames.contains(attr.getName().toUpperCase()))) continue;
            attr.setPrimaryKey(willBePrimaryKey);
            e.dbAttributeChanged(new AttributeEvent((Object)this, (Attribute)attr, (Entity)e));
            mergerContext.getDelegate().dbAttributeModified(attr);
        }
    }
}

