package org.apache.cayenne.testdo.inherit.auto;

import java.util.List;

import org.apache.cayenne.testdo.inherit.AbstractPerson;
import org.apache.cayenne.testdo.inherit.Address;
import org.apache.cayenne.testdo.inherit.Department;

/**
 * Class _Employee was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Employee extends AbstractPerson {

    public static final String SALARY_PROPERTY = "salary";
    public static final String ADDRESSES_PROPERTY = "addresses";
    public static final String TO_DEPARTMENT_PROPERTY = "toDepartment";

    public static final String PERSON_ID_PK_COLUMN = "PERSON_ID";

    public void setSalary(Float salary) {
        writeProperty("salary", salary);
    }
    public Float getSalary() {
        return (Float)readProperty("salary");
    }

    public void addToAddresses(Address obj) {
        addToManyTarget("addresses", obj, true);
    }
    public void removeFromAddresses(Address obj) {
        removeToManyTarget("addresses", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<Address> getAddresses() {
        return (List<Address>)readProperty("addresses");
    }


    public void setToDepartment(Department toDepartment) {
        setToOneTarget("toDepartment", toDepartment, true);
    }

    public Department getToDepartment() {
        return (Department)readProperty("toDepartment");
    }


}
