/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.select.RowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScalarRowReader
implements RowReader<Object> {
    private ExtendedType converter;
    private int index;
    private int jdbcType;

    ScalarRowReader(ExtendedType converter, int jdbcType) {
        this.converter = converter;
        this.index = 1;
        this.jdbcType = jdbcType;
    }

    @Override
    public void setColumnOffset(int offset) {
        this.index = offset + 1;
    }

    @Override
    public Object readRow(ResultSet resultSet) throws CayenneException {
        try {
            return this.converter.materializeObject(resultSet, this.index, this.jdbcType);
        }
        catch (CayenneException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneException("Exception materializing column.", Util.unwindException(otherex));
        }
    }
}

