/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.project.CayenneUserDir;
import org.apache.commons.collections.ExtendedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionProperties {
    public static final String EMBEDDED_DATASOURCE = "internal_embedded_datasource";
    public static final String EMBEDDED_DATASOURCE_DBADAPTER = "org.apache.cayenne.dba.hsqldb.HSQLDBAdapter";
    public static final String EMBEDDED_DATASOURCE_USERNAME = "sa";
    public static final String EMBEDDED_DATASOURCE_PASSWORD = "";
    public static final String EMBEDDED_DATASOURCE_URL = "jdbc:hsqldb:mem:aname";
    public static final String EMBEDDED_DATASOURCE_JDBC_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String PROPERTIES_FILE = "connection.properties";
    public static final String ADAPTER_KEY = "adapter";
    static final String ADAPTER20_KEY = "cayenne.adapter";
    public static final String USER_NAME_KEY = "jdbc.username";
    public static final String PASSWORD_KEY = "jdbc.password";
    public static final String URL_KEY = "jdbc.url";
    public static final String DRIVER_KEY = "jdbc.driver";
    protected static ConnectionProperties sharedInstance = ConnectionProperties.loadDefaultProperties();
    protected Map<String, DataSourceInfo> connectionInfos = Collections.synchronizedMap(new HashMap());

    public static ConnectionProperties getInstance() {
        return sharedInstance;
    }

    protected static ConnectionProperties loadDefaultProperties() {
        File f = CayenneUserDir.getInstance().resolveFile(PROPERTIES_FILE);
        try {
            if (f.exists()) {
                return new ConnectionProperties(new ExtendedProperties(f.getAbsolutePath()));
            }
            ConnectionProperties.createSamplePropertiesFile(f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ConnectionProperties(new ExtendedProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createSamplePropertiesFile(File f) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(f));
        try {
            out.write("# Cayenne named connections configuration file.");
            out.newLine();
            out.write("#");
            out.newLine();
            out.write("# Sample named connections (named 'example1' and 'example2'): ");
            out.newLine();
            out.write("#");
            out.newLine();
            out.write("# example1.adapter = org.apache.cayenne.dba.mysql.MySQLAdapter");
            out.newLine();
            out.write("# example1.jdbc.username = some_user");
            out.newLine();
            out.write("# example1.jdbc.password = some_passwd");
            out.newLine();
            out.write("# example1.jdbc.url = jdbc:mysql://noise/cayenne");
            out.newLine();
            out.write("# example1.jdbc.driver = org.gjt.mm.mysql.Driver");
            out.newLine();
            out.write("#");
            out.newLine();
            out.write("# example2.adapter = org.apache.cayenne.dba.mysql.MySQLAdapter");
            out.newLine();
            out.write("# example2.jdbc.username = some_user");
            out.newLine();
            out.write("# example2.jdbc.password = some_passwd");
            out.newLine();
            out.write("# example2.jdbc.url = jdbc:mysql://noise/cayenne");
            out.newLine();
            out.write("# example2.jdbc.driver = org.gjt.mm.mysql.Driver");
            out.newLine();
        }
        finally {
            out.close();
        }
    }

    public ConnectionProperties(ExtendedProperties props) {
        for (String name : this.extractNames(props)) {
            DataSourceInfo dsi = this.buildDataSourceInfo(props.subset(name));
            this.connectionInfos.put(name, dsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceInfo getConnectionInfo(String name) {
        if (EMBEDDED_DATASOURCE.equals(name)) {
            DataSourceInfo connectionInfo = new DataSourceInfo();
            connectionInfo.setAdapterClassName(EMBEDDED_DATASOURCE_DBADAPTER);
            connectionInfo.setUserName(EMBEDDED_DATASOURCE_USERNAME);
            connectionInfo.setPassword(EMBEDDED_DATASOURCE_PASSWORD);
            connectionInfo.setDataSourceUrl(EMBEDDED_DATASOURCE_URL);
            connectionInfo.setJdbcDriver(EMBEDDED_DATASOURCE_JDBC_DRIVER);
            return connectionInfo;
        }
        Map<String, DataSourceInfo> map = this.connectionInfos;
        synchronized (map) {
            return this.connectionInfos.get(name);
        }
    }

    protected DataSourceInfo buildDataSourceInfo(ExtendedProperties props) {
        DataSourceInfo dsi = new DataSourceInfo();
        String adapter = props.getString(ADAPTER_KEY);
        if (adapter == null) {
            adapter = props.getString(ADAPTER20_KEY);
        }
        dsi.setAdapterClassName(adapter);
        dsi.setUserName(props.getString(USER_NAME_KEY));
        dsi.setPassword(props.getString(PASSWORD_KEY));
        dsi.setDataSourceUrl(props.getString(URL_KEY));
        dsi.setJdbcDriver(props.getString(DRIVER_KEY));
        return dsi;
    }

    protected List<String> extractNames(ExtendedProperties props) {
        Iterator it = props.getKeys();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            String name;
            String key = (String)it.next();
            int dotInd = key.indexOf(46);
            if (dotInd <= 0 || dotInd >= key.length() || list.contains(name = key.substring(0, dotInd))) continue;
            list.add(name);
        }
        return list;
    }
}

