/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.enhancer;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.enhancer.EnhancementHelper;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class SetterVisitor
extends MethodAdapter {
    private EnhancementHelper helper;
    private String propertyName;
    private Type propertyType;

    public SetterVisitor(MethodVisitor mv, EnhancementHelper helper, String propertyName, Type propertyType) {
        super(mv);
        this.helper = helper;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public void visitCode() {
        super.visitCode();
        String field = this.helper.getPropertyField("objectContext");
        Type objectContextType = Type.getType(ObjectContext.class);
        String propertyDescriptor = this.propertyType.getDescriptor();
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.helper.getCurrentClass().getInternalName(), field, objectContextType.getDescriptor());
        Label l1 = new Label();
        this.mv.visitJumpInsn(198, l1);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.helper.getCurrentClass().getInternalName(), field, objectContextType.getDescriptor());
        this.mv.visitVarInsn(25, 0);
        this.mv.visitLdcInsn((Object)this.propertyName);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.helper.getCurrentClass().getInternalName(), this.propertyName, propertyDescriptor);
        if (!this.visitPrimitiveConversion(propertyDescriptor)) {
            this.mv.visitVarInsn(25, 1);
        }
        this.mv.visitMethodInsn(185, objectContextType.getInternalName(), "propertyChanged", "(Lorg/apache/cayenne/Persistent;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V");
        this.mv.visitLabel(l1);
    }

    protected boolean visitPrimitiveConversion(String propertyDescriptor) {
        if (propertyDescriptor.length() != 1) {
            return false;
        }
        switch (propertyDescriptor.charAt(0)) {
            case 'I': {
                this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                this.mv.visitVarInsn(21, 1);
                this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                return true;
            }
            case 'D': {
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                this.mv.visitVarInsn(24, 1);
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                return true;
            }
            case 'F': {
                this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                this.mv.visitVarInsn(23, 1);
                this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                return true;
            }
            case 'Z': {
                this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                this.mv.visitVarInsn(21, 1);
                this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                return true;
            }
            case 'J': {
                this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                this.mv.visitVarInsn(22, 1);
                this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                return true;
            }
            case 'B': {
                this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                this.mv.visitVarInsn(21, 1);
                this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                return true;
            }
            case 'C': {
                this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                this.mv.visitVarInsn(21, 1);
                this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                return true;
            }
            case 'S': {
                this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                this.mv.visitVarInsn(21, 1);
                this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                return true;
            }
        }
        return false;
    }
}

