/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.instrument;

import java.lang.instrument.Instrumentation;
import org.apache.cayenne.instrument.CayenneInstrumentationFactory;
import org.apache.cayenne.instrument.InstrumentationFactory;

public class InstrumentUtil {
    public static final String INSTRUMENTATION_FACTORY_PROPERTY = "org.apache.cayenne.instrument.factory";

    public static Instrumentation getInstrumentation() {
        InstrumentationFactory factory;
        String factoryName = System.getProperty(INSTRUMENTATION_FACTORY_PROPERTY);
        if (factoryName != null) {
            try {
                factory = (InstrumentationFactory)Class.forName(factoryName, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Throwable th) {
                throw new IllegalStateException("Invalid instrumentation factory: " + factoryName, th);
            }
        } else {
            factory = new CayenneInstrumentationFactory();
        }
        return factory.getInstrumentation();
    }
}

