/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.combo;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.util.combo.CustomTypeComboBoxEditor;
import org.apache.cayenne.modeler.util.combo.SuggestionList;

public class AutoCompletion
implements FocusListener,
KeyListener,
Runnable {
    public static final String AUTOCOMPLETION_PROPERTY = "JComboBox.autoCompletion";
    private final SuggestionList suggestionList;
    private final JComboBox comboBox;
    private final JTextComponent textEditor;
    private final boolean allowsUserValues;

    protected AutoCompletion(JComboBox comboBox, boolean strict, boolean allowsUserValues) {
        this.comboBox = comboBox;
        this.textEditor = (JTextComponent)comboBox.getEditor().getEditorComponent();
        this.allowsUserValues = allowsUserValues;
        this.suggestionList = new SuggestionList(comboBox, strict);
        comboBox.putClientProperty(AUTOCOMPLETION_PROPERTY, Boolean.TRUE);
    }

    public static void enable(JComboBox comboBox, boolean strict, boolean allowsUserValues) {
        comboBox.setEditable(true);
        comboBox.setEditor(new CustomTypeComboBoxEditor(comboBox, allowsUserValues));
        AutoCompletion ac = new AutoCompletion(comboBox, strict, allowsUserValues);
        comboBox.addFocusListener(ac);
        ac.textEditor.addKeyListener(ac);
        SwingUtilities.replaceUIActionMap(comboBox, null);
    }

    public static void enable(JComboBox comboBox) {
        AutoCompletion.enable(comboBox, true, false);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.suggestionList.hide();
    }

    public void keyPressed(KeyEvent e) {
        this.handleKeyPressed(this.comboBox, e);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void run() {
        String text = this.textEditor.getText();
        this.suggestionList.hide();
        if (this.comboBox.isShowing()) {
            this.suggestionList.filter(text);
            if (this.suggestionList.getItemCount() > 0) {
                this.suggestionList.show();
            }
        }
    }

    private void handleKeyPressed(JComboBox comboBox, KeyEvent e) {
        int next;
        int max;
        int sel;
        boolean suggest = this.suggestionList.isVisible();
        if (suggest) {
            sel = this.suggestionList.getSelectedIndex();
            max = this.suggestionList.getItemCount() - 1;
        } else {
            sel = comboBox.getSelectedIndex();
            max = comboBox.getItemCount() - 1;
        }
        switch (e.getKeyCode()) {
            case 38: 
            case 104: {
                next = sel - 1;
                break;
            }
            case 40: 
            case 98: {
                next = sel + 1;
                break;
            }
            case 33: {
                next = sel - comboBox.getMaximumRowCount();
                break;
            }
            case 34: {
                next = sel + comboBox.getMaximumRowCount();
                break;
            }
            case 36: {
                next = 0;
                break;
            }
            case 35: {
                next = max;
                break;
            }
            case 10: {
                if (suggest) {
                    Object value = this.suggestionList.getSelectedValue();
                    if (!this.allowsUserValues && value == null && this.suggestionList.getItemCount() > 0) {
                        value = this.suggestionList.getItemAt(0);
                    }
                    if (value != null || !this.allowsUserValues) {
                        comboBox.setSelectedItem(value);
                    }
                    this.suggestionList.hide();
                }
                return;
            }
            case 27: {
                if (suggest) {
                    this.suggestionList.hide();
                }
                return;
            }
            case 16: 
            case 17: 
            case 18: {
                return;
            }
            default: {
                SwingUtilities.invokeLater(this);
                return;
            }
        }
        e.consume();
        if (!suggest && !comboBox.isPopupVisible()) {
            comboBox.setPopupVisible(true);
            return;
        }
        if (comboBox.getItemCount() > 0) {
            if (next < 0) {
                next = 0;
            }
            if (next > max) {
                next = max;
            }
            if (next != sel) {
                if (suggest) {
                    this.suggestionList.setSelectedIndex(next);
                } else {
                    comboBox.setPopupVisible(true);
                    comboBox.setSelectedIndex(next);
                }
            }
            this.textEditor.requestFocus();
        }
    }
}

