/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.cayenne.swing.BindingBase;
import org.apache.cayenne.swing.BindingException;
import org.apache.cayenne.swing.BindingExpression;
import org.apache.cayenne.util.Util;
import org.apache.commons.collections.map.SingletonMap;

public class TableBinding
extends BindingBase {
    public static final String ITEM_VAR = "item";
    protected JTable table;
    protected String[] headers;
    protected BindingExpression[] columns;
    protected boolean[] editableState;
    protected Class[] columnClass;
    protected List list;

    public TableBinding(JTable table, String listBinding, String[] headers, BindingExpression[] columns, Class[] columnClass, boolean[] editableState, Object[] sampleLongValues) {
        super(listBinding);
        this.table = table;
        this.headers = headers;
        this.columns = columns;
        this.editableState = editableState;
        this.columnClass = columnClass;
        table.setModel(new BoundTableModel());
        this.resizeColumns(sampleLongValues);
    }

    protected void resizeColumns(Object[] sampleLongValues) {
        TableCellRenderer headerRenderer = this.table.getTableHeader().getDefaultRenderer();
        TableColumnModel columnModel = this.table.getColumnModel();
        TableModel tableModel = this.table.getModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            Component header = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int headerWidth = header.getPreferredSize().width;
            if (sampleLongValues[i] != null) {
                Component bigCell = this.table.getDefaultRenderer(tableModel.getColumnClass(i)).getTableCellRendererComponent(this.table, sampleLongValues[i], false, false, 0, i);
                int cellWidth = bigCell.getPreferredSize().width;
                column.setPreferredWidth(Math.max(headerWidth, cellWidth));
                continue;
            }
            column.setPreferredWidth(headerWidth);
        }
    }

    public void setContext(Object object) {
        super.setContext(object);
        this.list = this.updateList();
    }

    public Component getView() {
        return this.table;
    }

    public void updateView() {
        this.list = this.updateList();
        ((BoundTableModel)this.table.getModel()).fireTableDataChanged();
    }

    int getListSize() {
        return this.list != null ? this.list.size() : 0;
    }

    List updateList() {
        if (this.getContext() == null) {
            return null;
        }
        Object list = this.getValue();
        if (list == null) {
            return null;
        }
        if (list instanceof List) {
            return (List)list;
        }
        if (list instanceof Object[]) {
            Object[] objects = (Object[])list;
            return Arrays.asList(objects);
        }
        if (list instanceof Collection) {
            return new ArrayList((Collection)list);
        }
        throw new BindingException("List expected, got - " + list);
    }

    final class BoundTableModel
    extends AbstractTableModel {
        Map listContext = new SingletonMap((Object)"item", null);

        BoundTableModel() {
        }

        public int getColumnCount() {
            return TableBinding.this.headers.length;
        }

        public int getRowCount() {
            return TableBinding.this.getListSize();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return TableBinding.this.editableState[columnIndex];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object item = TableBinding.this.list.get(rowIndex);
            this.listContext.put(TableBinding.ITEM_VAR, item);
            return TableBinding.this.columns[columnIndex].getValue(TableBinding.this.getContext(), this.listContext);
        }

        public String getColumnName(int column) {
            return Util.isEmptyString((String)TableBinding.this.headers[column]) ? " " : TableBinding.this.headers[column];
        }

        public Class getColumnClass(int columnIndex) {
            return TableBinding.this.columnClass[columnIndex];
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Object item = TableBinding.this.list.get(rowIndex);
            this.listContext.put(TableBinding.ITEM_VAR, item);
            TableBinding.this.columns[columnIndex].setValue(TableBinding.this.getContext(), this.listContext, value);
        }
    }
}

