/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.objectstyle.ashwood.graph.layout.Layer;
import org.objectstyle.ashwood.graph.layout.LayerVertex;

public class ArcStraightener {
    private Layer[] layers;
    private SortedMap classes;
    private double horizontalSpacing;

    public void positionDummies(Layer[] layers, double horizontalSpacing) {
        this.layers = layers;
        this.horizontalSpacing = horizontalSpacing;
        this.computeLeftPositions();
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].size(); ++j) {
                layers[i].getVertex(j).setClassIndex(-1);
            }
        }
        this.computeRightPositions();
        this.position();
    }

    private void computeLeftPositions() {
        this.computeClasses(true);
        for (Map.Entry entry : this.classes.entrySet()) {
            int classIndex = entry.getKey().hashCode();
            List clazz = (List)entry.getValue();
            for (int j = 0; j < clazz.size(); ++j) {
                LayerVertex v = (LayerVertex)clazz.get(j);
                if (v.isDefinedLeftX()) continue;
                this.placeLeft(v);
            }
            this.adjustLeftClass(classIndex);
        }
    }

    private void computeRightPositions() {
        this.computeClasses(false);
        for (Map.Entry entry : this.classes.entrySet()) {
            int classIndex = entry.getKey().hashCode();
            List clazz = (List)entry.getValue();
            for (int j = 0; j < clazz.size(); ++j) {
                LayerVertex v = (LayerVertex)clazz.get(j);
                if (v.isDefinedRightX()) continue;
                this.placeRight(v);
            }
            this.adjustRightClass(classIndex);
        }
    }

    private void position() {
        for (int i = 0; i < this.layers.length; ++i) {
            for (int j = 0; j < this.layers[i].size(); ++j) {
                LayerVertex v = this.layers[i].getVertex(j);
                v.setCenterX((v.getLeftX() + v.getRightX()) / 2.0);
            }
        }
    }

    private void computeClasses(boolean left) {
        this.classes = new TreeMap();
        for (int i = 0; i < this.layers.length; ++i) {
            int classIndex = i;
            int start = left ? 0 : this.layers[i].size() - 1;
            int end = left ? this.layers[i].size() : -1;
            int step = left ? 1 : -1;
            block1: for (int j = start; j != end; j += step) {
                LayerVertex v = this.layers[i].getVertex(j);
                if (v.getClassIndex() >= 0) {
                    classIndex = v.getClassIndex();
                    continue;
                }
                List clazz = this.getClazz(classIndex);
                if (!v.isDummy()) {
                    v.setClassIndex(classIndex);
                    clazz.add(v);
                    continue;
                }
                while (v.isDummy()) {
                    v.setClassIndex(classIndex);
                    clazz.add(v);
                    if (v.outDegree() != 1) continue block1;
                    v = v.getSuccessor(0);
                }
            }
        }
    }

    private List getClazz(int index) {
        Integer key = new Integer(index);
        ArrayList clazz = (ArrayList)this.classes.get(key);
        if (clazz == null) {
            clazz = new ArrayList();
            this.classes.put(key, clazz);
        }
        return clazz;
    }

    private void placeLeft(LayerVertex vertex) {
        Layer layer = this.layers[vertex.getRank()];
        double vertexPosition = Double.NEGATIVE_INFINITY;
        if (!vertex.isDummy()) {
            if (layer.isFirst(vertex)) {
                vertexPosition = 0.0;
            } else {
                LayerVertex leftNeighbor = layer.getLeft(vertex);
                if (leftNeighbor.getClassIndex() == vertex.getClassIndex()) {
                    if (!leftNeighbor.isDefinedLeftX()) {
                        this.placeLeft(leftNeighbor);
                    }
                    double distance = vertex.minCenterDistance(leftNeighbor, this.horizontalSpacing);
                    vertexPosition = leftNeighbor.getLeftX() + distance;
                } else {
                    vertexPosition = 0.0;
                }
            }
            vertex.setLeftX(vertexPosition);
        } else {
            LayerVertex v = vertex;
            while (vertex.isDummy()) {
                LayerVertex leftNeighbor;
                layer = this.layers[vertex.getRank()];
                if (!layer.isFirst(vertex) && (leftNeighbor = layer.getLeft(vertex)).getClassIndex() == vertex.getClassIndex()) {
                    if (!leftNeighbor.isDefinedLeftX()) {
                        this.placeLeft(leftNeighbor);
                    }
                    double distance = vertex.minCenterDistance(leftNeighbor, this.horizontalSpacing);
                    vertexPosition = Math.max(vertexPosition, leftNeighbor.getLeftX() + distance);
                }
                if (vertex.outDegree() != 1) break;
                vertex = vertex.getSuccessor(0);
            }
            vertexPosition = Double.isInfinite(vertexPosition) ? 0.0 : vertexPosition;
            vertex = v;
            while (vertex.isDummy()) {
                vertex.setLeftX(vertexPosition);
                if (vertex.outDegree() != 1) break;
                vertex = vertex.getSuccessor(0);
            }
        }
    }

    private void placeRight(LayerVertex vertex) {
        Layer layer = this.layers[vertex.getRank()];
        double vertexPosition = Double.POSITIVE_INFINITY;
        if (!vertex.isDummy()) {
            if (layer.isLast(vertex)) {
                vertexPosition = 0.0;
            } else {
                LayerVertex rightNeighbor = layer.getRight(vertex);
                if (rightNeighbor.getClassIndex() == vertex.getClassIndex()) {
                    try {
                        if (!rightNeighbor.isDefinedRightX()) {
                            this.placeRight(rightNeighbor);
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    double distance = vertex.minCenterDistance(rightNeighbor, this.horizontalSpacing);
                    vertexPosition = rightNeighbor.getRightX() - distance;
                } else {
                    vertexPosition = 0.0;
                }
            }
            vertex.setRightX(vertexPosition);
        } else {
            LayerVertex v = vertex;
            while (vertex.isDummy()) {
                LayerVertex rightNeighbor;
                layer = this.layers[vertex.getRank()];
                if (!layer.isLast(vertex) && (rightNeighbor = layer.getRight(vertex)).getClassIndex() == vertex.getClassIndex()) {
                    if (!rightNeighbor.isDefinedRightX()) {
                        this.placeRight(rightNeighbor);
                    }
                    double distance = vertex.minCenterDistance(rightNeighbor, this.horizontalSpacing);
                    vertexPosition = Math.min(vertexPosition, rightNeighbor.getRightX() - distance);
                }
                if (vertex.outDegree() != 1) break;
                vertex = vertex.getSuccessor(0);
            }
            vertexPosition = Double.isInfinite(vertexPosition) ? 0.0 : vertexPosition;
            vertex = v;
            while (vertex.isDummy()) {
                vertex.setRightX(vertexPosition);
                if (vertex.outDegree() != 1) break;
                vertex = vertex.getSuccessor(0);
            }
        }
    }

    private void adjustLeftClass(int classIndex) {
        int i;
        List clazz = (List)this.classes.get(new Integer(classIndex));
        double d = Double.POSITIVE_INFINITY;
        for (i = 0; i < clazz.size(); ++i) {
            LayerVertex rightNeighbor;
            LayerVertex v = (LayerVertex)clazz.get(i);
            Layer layer = this.layers[v.getRank()];
            if (layer.isLast(v) || (rightNeighbor = layer.getRight(v)).getClassIndex() == classIndex) continue;
            double distance = v.minCenterDistance(rightNeighbor, this.horizontalSpacing);
            d = Math.min(d, rightNeighbor.getLeftX() - v.getLeftX() - distance);
        }
        if (Double.isInfinite(d)) {
            ArrayList<Double> heap = new ArrayList<Double>(clazz.size() + 1);
            for (int i2 = 0; i2 < clazz.size(); ++i2) {
                LayerVertex w;
                int j;
                LayerVertex v = (LayerVertex)clazz.get(i2);
                for (j = 0; j < v.inDegree(); ++j) {
                    w = v.getPredecessor(j);
                    if (w.getClassIndex() >= classIndex) continue;
                    heap.add(new Double(w.getLeftX() - v.getLeftX()));
                }
                for (j = 0; j < v.outDegree(); ++j) {
                    w = v.getSuccessor(j);
                    if (w.getClassIndex() >= classIndex) continue;
                    heap.add(new Double(w.getLeftX() - v.getLeftX()));
                }
            }
            if (heap.size() == 0) {
                d = 0.0;
            } else {
                Collections.sort(heap);
                d = (Double)heap.get(heap.size() / 2);
            }
        }
        for (i = 0; i < clazz.size(); ++i) {
            LayerVertex v = (LayerVertex)clazz.get(i);
            v.setLeftX(v.getLeftX() + d);
        }
    }

    private void adjustRightClass(int classIndex) {
        int i;
        List clazz = (List)this.classes.get(new Integer(classIndex));
        double d = Double.POSITIVE_INFINITY;
        for (i = 0; i < clazz.size(); ++i) {
            LayerVertex leftNeighbor;
            LayerVertex v = (LayerVertex)clazz.get(i);
            Layer layer = this.layers[v.getRank()];
            if (layer.isFirst(v) || (leftNeighbor = layer.getLeft(v)).getClassIndex() == classIndex) continue;
            double distance = v.minCenterDistance(leftNeighbor, this.horizontalSpacing);
            d = Math.min(d, v.getRightX() - leftNeighbor.getRightX() - distance);
        }
        if (Double.isInfinite(d)) {
            ArrayList<Double> heap = new ArrayList<Double>(clazz.size() + 1);
            for (int i2 = 0; i2 < clazz.size(); ++i2) {
                LayerVertex w;
                int j;
                LayerVertex v = (LayerVertex)clazz.get(i2);
                for (j = 0; j < v.inDegree(); ++j) {
                    w = v.getPredecessor(j);
                    if (w.getClassIndex() >= classIndex) continue;
                    heap.add(new Double(w.getRightX() - v.getRightX()));
                }
                for (j = 0; j < v.outDegree(); ++j) {
                    w = v.getSuccessor(j);
                    if (w.getClassIndex() >= classIndex) continue;
                    heap.add(new Double(w.getRightX() - v.getRightX()));
                }
            }
            if (heap.size() == 0) {
                d = 0.0;
            } else {
                Collections.sort(heap);
                d = -((Double)heap.get(heap.size() / 2)).doubleValue();
            }
        }
        for (i = 0; i < clazz.size(); ++i) {
            LayerVertex v = (LayerVertex)clazz.get(i);
            v.setRightX(v.getRightX() - d);
        }
    }

    private void printLayers() {
        for (int i = 0; i < this.layers.length; ++i) {
            for (int j = 0; j < this.layers[i].size(); ++j) {
                LayerVertex v = this.layers[i].getVertex(j);
                System.out.println("v=" + v.getUserVertex() + ", c=" + v.getClassIndex() + ", lx=" + v.getLeftX() + ", rx=" + v.getRightX() + ", w=" + v.getWidth());
            }
        }
    }
}

