/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class ShortType
implements ExtendedType {
    protected boolean widenShorts;

    public ShortType(boolean widenShorts) {
        this.widenShorts = widenShorts;
    }

    public String getClassName() {
        return Short.class.getName();
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        short s = rs.getShort(index);
        return rs.wasNull() ? null : Short.valueOf(s);
    }

    public Object materializeObject(CallableStatement st, int index, int type) throws Exception {
        short s = st.getShort(index);
        return st.wasNull() ? null : Short.valueOf(s);
    }

    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int precision) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            Short s = (Short)value;
            if (this.widenShorts) {
                statement.setInt(pos, s.intValue());
            } else {
                statement.setShort(pos, s);
            }
        }
    }

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        if (dbAttribute.isMandatory() && value == null) {
            validationResult.addFailure(new BeanValidationFailure(source, property, "'" + property + "' must be not null"));
            return false;
        }
        return true;
    }
}

