/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.WeakHashMap;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.ContextClassLoaderLocal;
import org.apache.commons.beanutils2.ConvertUtils;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.PrimitiveBean;
import org.apache.commons.beanutils2.locale.LocaleBeanUtils;
import org.apache.commons.beanutils2.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils2.locale.LocaleConvertUtils;
import org.apache.commons.beanutils2.locale.LocaleConvertUtilsBean;
import org.apache.commons.beanutils2.locale.LocaleConverter;
import org.apache.commons.beanutils2.locale.converters.LongLocaleConverter;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LocaleBeanificationTest {
    public static final int MAX_GC_ITERATIONS = 50;

    @BeforeEach
    public void setUp() {
        LocaleConvertUtils.deregister();
    }

    @Test
    public void testBeanUtilsBeanSetInstance() throws Exception {
        Signal signal = new Signal();
        signal.setSignal(1);
        LocaleBeanUtilsBean beanOne = new LocaleBeanUtilsBean();
        LocaleBeanUtilsBean beanTwo = new LocaleBeanUtilsBean();
        final class SetInstanceTesterThread
        extends Thread {
            private final Signal signal;
            private final LocaleBeanUtilsBean bean;

            SetInstanceTesterThread(Signal signal, LocaleBeanUtilsBean bean) {
                this.signal = signal;
                this.bean = bean;
            }

            @Override
            public void run() {
                LocaleBeanUtilsBean.setInstance((LocaleBeanUtilsBean)this.bean);
                this.signal.setSignal(21);
                this.signal.setBean(LocaleBeanUtilsBean.getLocaleBeanUtilsInstance());
            }

            @Override
            public String toString() {
                return "SetInstanceTesterThread";
            }
        }
        SetInstanceTesterThread thread = new SetInstanceTesterThread(signal, beanTwo);
        thread.setContextClassLoader(new TestClassLoader());
        LocaleBeanUtilsBean.setInstance((LocaleBeanUtilsBean)beanOne);
        Assertions.assertEquals((Object)beanOne, (Object)LocaleBeanUtilsBean.getLocaleBeanUtilsInstance(), (String)"Start thread gets right instance");
        thread.start();
        thread.join();
        Assertions.assertEquals((int)21, (int)signal.getSignal(), (String)"Signal not set by test thread");
        Assertions.assertEquals((Object)beanOne, (Object)LocaleBeanUtilsBean.getLocaleBeanUtilsInstance(), (String)"Second thread preserves value");
        Assertions.assertEquals((Object)beanTwo, (Object)signal.getBean(), (String)"Second thread gets value it set");
    }

    @Test
    public void testContextClassloaderIndependence() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        LocaleBeanUtils.setProperty((Object)bean, (String)"int", (Object)new Integer(1));
        Assertions.assertEquals((int)1, (int)bean.getInt(), (String)"Wrong property value (1)");
        LocaleConvertUtils.register((LocaleConverter)new LocaleConverter<Integer>(){

            public <R> R convert(Class<R> type, Object value) {
                return (R)ConvertUtils.primitiveToWrapper(type).cast(5);
            }

            public <R> R convert(Class<R> type, Object value, String pattern) {
                return (R)ConvertUtils.primitiveToWrapper(type).cast(5);
            }
        }, Integer.TYPE, (Locale)Locale.getDefault());
        LocaleBeanUtils.setProperty((Object)bean, (String)"int", (Object)"1");
        Assertions.assertEquals((int)5, (int)bean.getInt(), (String)"Wrong property value(2)");
        Signal signal = new Signal();
        signal.setSignal(1);
        final class TestIndependenceThread
        extends Thread {
            private final Signal signal;
            private final PrimitiveBean bean;

            TestIndependenceThread(Signal signal, PrimitiveBean bean) {
                this.signal = signal;
                this.bean = bean;
            }

            @Override
            public void run() {
                try {
                    this.signal.setSignal(3);
                    LocaleConvertUtils.register((LocaleConverter)new LocaleConverter<Integer>(){

                        public <R> R convert(Class<R> type, Object value) {
                            return (R)ConvertUtils.primitiveToWrapper(type).cast(9);
                        }

                        public <R> R convert(Class<R> type, Object value, String pattern) {
                            return (R)ConvertUtils.primitiveToWrapper(type).cast(9);
                        }
                    }, Integer.TYPE, (Locale)Locale.getDefault());
                    LocaleBeanUtils.setProperty((Object)this.bean, (String)"int", (Object)"1");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.signal.setException(e);
                }
            }

            @Override
            public String toString() {
                return "TestIndependenceThread";
            }
        }
        TestIndependenceThread thread = new TestIndependenceThread(signal, bean);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        Assertions.assertNull((Object)signal.getException(), (String)("Exception thrown by test thread:" + signal.getException()));
        Assertions.assertEquals((int)3, (int)signal.getSignal(), (String)"Signal not set by test thread");
        Assertions.assertEquals((int)9, (int)bean.getInt(), (String)"Wrong property value(3)");
    }

    @Test
    public void testContextClassLoaderLocal() throws Exception {
        ContextClassLoaderLocal ccll = new ContextClassLoaderLocal();
        ccll.set((Object)1776);
        Assertions.assertEquals((Integer)new Integer(1776), (Integer)((Integer)ccll.get()), (String)"Start thread sets value");
        Signal signal = new Signal();
        signal.setSignal(1);
        final class CCLLTesterThread
        extends Thread {
            private final Signal signal;
            private final ContextClassLoaderLocal<Integer> ccll;

            CCLLTesterThread(Signal signal, ContextClassLoaderLocal<Integer> ccll) {
                this.signal = signal;
                this.ccll = ccll;
            }

            @Override
            public void run() {
                this.ccll.set((Object)new Integer(1789));
                this.signal.setSignal(2);
                this.signal.setMarkerObject(this.ccll.get());
            }

            @Override
            public String toString() {
                return "CCLLTesterThread";
            }
        }
        CCLLTesterThread thread = new CCLLTesterThread(signal, (ContextClassLoaderLocal<Integer>)ccll);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        Assertions.assertEquals((int)2, (int)signal.getSignal(), (String)"Signal not set by test thread");
        Assertions.assertEquals((Integer)new Integer(1776), (Integer)((Integer)ccll.get()), (String)"Second thread preserves value");
        Assertions.assertEquals((Object)new Integer(1789), (Object)signal.getMarkerObject(), (String)"Second thread gets value it set");
    }

    @Test
    public void testContextClassLoaderUnset() {
        LocaleBeanUtilsBean beanOne = new LocaleBeanUtilsBean();
        ContextClassLoaderLocal ccll = new ContextClassLoaderLocal();
        ccll.set((Object)beanOne);
        Assertions.assertEquals((Object)beanOne, (Object)ccll.get(), (String)"Start thread gets right instance");
        ccll.unset();
        Assertions.assertTrue((!beanOne.equals(ccll.get()) ? 1 : 0) != 0, (String)"Unset works");
    }

    @Test
    public void testGetByContextClassLoader() throws Exception {
        Signal signal = new Signal();
        signal.setSignal(1);
        final class GetBeanUtilsBeanThread
        extends Thread {
            private final Signal signal;

            GetBeanUtilsBeanThread(Signal signal) {
                this.signal = signal;
            }

            @Override
            public void run() {
                this.signal.setSignal(2);
                this.signal.setBean(LocaleBeanUtilsBean.getLocaleBeanUtilsInstance());
                this.signal.setConvertUtils(LocaleConvertUtilsBean.getInstance());
            }

            @Override
            public String toString() {
                return "GetBeanUtilsBeanThread";
            }
        }
        GetBeanUtilsBeanThread thread = new GetBeanUtilsBeanThread(signal);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        Assertions.assertEquals((int)2, (int)signal.getSignal(), (String)"Signal not set by test thread");
        Assertions.assertTrue((BeanUtilsBean.getInstance() != signal.getBean() ? 1 : 0) != 0, (String)"Different LocaleBeanUtilsBean instances per context classloader");
        Assertions.assertTrue((LocaleConvertUtilsBean.getInstance() != signal.getConvertUtils() ? 1 : 0) != 0, (String)"Different LocaleConvertUtilsBean instances per context classloader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocaleAwareConverterInConvertUtils() {
        try {
            Long data = (Long)ConvertUtils.convert((String)"777", Long.class);
            Assertions.assertEquals((long)777L, (long)data, (String)"Standard format long converted ok");
            data = (Long)ConvertUtils.convert((String)"1.000.000", Long.class);
            Assertions.assertEquals((long)0L, (long)data, (String)"Standard format behaved as expected");
            Locale germanLocale = Locale.GERMAN;
            LongLocaleConverter longLocaleConverter = ((LongLocaleConverter.Builder)LongLocaleConverter.builder().setLocale(germanLocale)).get();
            ConvertUtils.register((Converter)longLocaleConverter, Long.class);
            data = (Long)ConvertUtils.convert((String)"1.000.000", Long.class);
            Assertions.assertEquals((long)1000000L, (long)data, (String)"German-format long converted ok");
        }
        finally {
            ConvertUtils.deregister();
        }
    }

    @Test
    public void testMemoryLeak() throws Exception {
        TestClassLoader loader = new TestClassLoader();
        WeakReference<TestClassLoader> loaderReference = new WeakReference<TestClassLoader>(loader);
        LocaleBeanUtilsBean.getLocaleBeanUtilsInstance();
        final class GetBeanUtilsBeanThread
        extends Thread {
            LocaleBeanUtilsBean beanUtils;
            LocaleConvertUtilsBean convertUtils;

            GetBeanUtilsBeanThread() {
            }

            @Override
            public void run() {
                this.beanUtils = LocaleBeanUtilsBean.getLocaleBeanUtilsInstance();
                this.convertUtils = LocaleConvertUtilsBean.getInstance();
                LogFactory.releaseAll();
            }

            @Override
            public String toString() {
                return "GetBeanUtilsBeanThread";
            }
        }
        GetBeanUtilsBeanThread thread = new GetBeanUtilsBeanThread();
        WeakReference<GetBeanUtilsBeanThread> threadWeakReference = new WeakReference<GetBeanUtilsBeanThread>(thread);
        thread.setContextClassLoader(loader);
        thread.start();
        thread.join();
        WeakReference<LocaleBeanUtilsBean> beanUtilsReference = new WeakReference<LocaleBeanUtilsBean>(thread.beanUtils);
        WeakReference<LocaleConvertUtilsBean> convertUtilsReference = new WeakReference<LocaleConvertUtilsBean>(thread.convertUtils);
        Assertions.assertNotNull(loaderReference.get(), (String)"Weak reference released early (1)");
        Assertions.assertNotNull(beanUtilsReference.get(), (String)"Weak reference released early (2)");
        Assertions.assertNotNull(convertUtilsReference.get(), (String)"Weak reference released early (4)");
        loader = null;
        thread.setContextClassLoader(null);
        thread = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            LocaleBeanUtilsBean.getLocaleBeanUtilsInstance();
            System.gc();
            Assertions.assertFalse((iterations++ > 50 ? 1 : 0) != 0, (String)"Max iterations reached before resource released.");
            if (loaderReference.get() == null && beanUtilsReference.get() == null && convertUtilsReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    @Test
    public void testMemoryLeak2() {
        TestClassLoader loader = new TestClassLoader();
        ReferenceQueue queue = new ReferenceQueue();
        WeakReference<TestClassLoader> loaderReference = new WeakReference<TestClassLoader>(loader, queue);
        Integer test = new Integer(1);
        WeakReference<Integer> testReference = new WeakReference<Integer>(test, queue);
        WeakHashMap<TestClassLoader, Integer> map = new WeakHashMap<TestClassLoader, Integer>();
        map.put(loader, test);
        Assertions.assertEquals((Integer)test, (Integer)((Integer)map.get(loader)), (String)"In map");
        Assertions.assertNotNull(loaderReference.get(), (String)"Weak reference released early (1)");
        Assertions.assertNotNull(testReference.get(), (String)"Weak reference released early (2)");
        loader = null;
        test = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            Assertions.assertFalse((iterations++ > 50 ? 1 : 0) != 0, (String)"Max iterations reached before resource released.");
            map.isEmpty();
            if (loaderReference.get() == null && testReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    @Test
    public void testMemoryTestMethodology() throws Exception {
        ClassLoader loader = new ClassLoader(this.getClass().getClassLoader()){};
        WeakReference<2> reference = new WeakReference<2>(loader);
        Class<?> myClass = loader.loadClass("org.apache.commons.beanutils2.BetaBean");
        Assertions.assertNotNull(reference.get(), (String)"Weak reference released early");
        loader = null;
        myClass = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            Assertions.assertFalse((iterations++ > 50 ? 1 : 0) != 0, (String)"Max iterations reached before resource released.");
            if (reference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    final class Signal {
        private Exception e;
        private int signal;
        private LocaleBeanUtilsBean bean;
        private LocaleConvertUtilsBean convertUtils;
        private Object marker;

        Signal() {
        }

        public LocaleBeanUtilsBean getBean() {
            return this.bean;
        }

        public LocaleConvertUtilsBean getConvertUtils() {
            return this.convertUtils;
        }

        public Exception getException() {
            return this.e;
        }

        public Object getMarkerObject() {
            return this.marker;
        }

        public int getSignal() {
            return this.signal;
        }

        public void setBean(LocaleBeanUtilsBean bean) {
            this.bean = bean;
        }

        public void setConvertUtils(LocaleConvertUtilsBean convertUtils) {
            this.convertUtils = convertUtils;
        }

        public void setException(Exception e) {
            this.e = e;
        }

        public void setMarkerObject(Object marker) {
            this.marker = marker;
        }

        public void setSignal(int signal) {
            this.signal = signal;
        }
    }

    final class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public String toString() {
            return "TestClassLoader";
        }
    }
}

