/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.remote.MockRemoteCacheService;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;

public class ZombieRemoteCacheServiceUnitTest
extends TestCase {
    public void testUpdateThenWalk() throws Exception {
        MockRemoteCacheService service = new MockRemoteCacheService();
        ZombieCacheServiceNonLocal zombie = new ZombieCacheServiceNonLocal(10);
        String cacheName = "testUpdate";
        CacheElement element = new CacheElement("testUpdate", (Object)"key", (Object)"value");
        zombie.update((ICacheElement)element, 123L);
        zombie.propagateEvents(service);
        ZombieRemoteCacheServiceUnitTest.assertEquals((String)"Updated element is not as expected.", (Object)element, service.lastUpdate);
    }

    public void testUpdateThenWalk_zeroSize() throws Exception {
        MockRemoteCacheService service = new MockRemoteCacheService();
        ZombieCacheServiceNonLocal zombie = new ZombieCacheServiceNonLocal(0);
        String cacheName = "testUpdate";
        CacheElement element = new CacheElement("testUpdate", (Object)"key", (Object)"value");
        zombie.update((ICacheElement)element, 123L);
        zombie.propagateEvents(service);
        ZombieRemoteCacheServiceUnitTest.assertNull((String)"Nothing should have been put to the service.", service.lastUpdate);
    }

    public void testRemoveThenWalk() throws Exception {
        MockRemoteCacheService service = new MockRemoteCacheService();
        ZombieCacheServiceNonLocal zombie = new ZombieCacheServiceNonLocal(10);
        String cacheName = "testRemoveThenWalk";
        String key = "myKey";
        zombie.remove("testRemoveThenWalk", (Object)"myKey", 123L);
        zombie.propagateEvents(service);
        ZombieRemoteCacheServiceUnitTest.assertEquals((String)"Updated element is not as expected.", (String)"myKey", (String)((String)service.lastRemoveKey));
    }

    public void testRemoveAllThenWalk() throws Exception {
        MockRemoteCacheService service = new MockRemoteCacheService();
        ZombieCacheServiceNonLocal zombie = new ZombieCacheServiceNonLocal(10);
        String cacheName = "testRemoveThenWalk";
        zombie.removeAll("testRemoveThenWalk", 123L);
        zombie.propagateEvents(service);
        ZombieRemoteCacheServiceUnitTest.assertEquals((String)"Updated element is not as expected.", (String)"testRemoveThenWalk", (String)service.lastRemoveAllCacheName);
    }
}

