/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent.locks;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ThreadUtils;
import org.apache.commons.lang3.concurrent.locks.LockingVisitors;
import org.apache.commons.lang3.function.FailableConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class LockingVisitorsTest
extends AbstractLangTest {
    private static final Duration SHORT_DELAY = Duration.ofMillis(100L);
    private static final Duration DELAY = Duration.ofMillis(1500L);
    private static final int NUMBER_OF_THREADS = 10;
    private static final Duration TOTAL_DELAY = DELAY.multipliedBy(10L);

    LockingVisitorsTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsTrue(boolean[] booleanArray) {
        boolean[] blArray = booleanArray;
        synchronized (booleanArray) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ArrayUtils.contains((boolean[])booleanArray, (boolean)true);
        }
    }

    private void runTest(Duration delay, boolean exclusiveLock, LongConsumer runTimeCheck, boolean[] booleanValues, LockingVisitors.LockVisitor<boolean[], ?> visitor) throws InterruptedException {
        Assertions.assertNotNull((Object)visitor.getLock());
        Assertions.assertNotNull((Object)visitor.getObject());
        boolean[] runningValues = new boolean[10];
        for (int i = 0; i < booleanValues.length; ++i) {
            int index = i;
            FailableConsumer consumer = b -> {
                b[index] = false;
                ThreadUtils.sleep((Duration)delay);
                b[index] = true;
                this.set(runningValues, index, false);
            };
            Thread t = new Thread(() -> {
                if (exclusiveLock) {
                    visitor.acceptWriteLocked(consumer);
                } else {
                    visitor.acceptReadLocked(consumer);
                }
            });
            this.set(runningValues, i, true);
            t.start();
        }
        while (this.containsTrue(runningValues)) {
            ThreadUtils.sleep((Duration)SHORT_DELAY);
        }
        for (boolean booleanValue : booleanValues) {
            Assertions.assertTrue((boolean)booleanValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(boolean[] booleanArray, int offset, boolean value) {
        boolean[] blArray = booleanArray;
        synchronized (booleanArray) {
            booleanArray[offset] = value;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testBuilderLockVisitor(boolean fair) {
        AtomicInteger obj = new AtomicInteger();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(fair);
        LockingVisitors.LockVisitor lockVisitor = new LockingVisitors.LockVisitor.LVBuilder().setObject((Object)obj).setLock((Object)lock).setReadLockSupplier(lock::readLock).setWriteLockSupplier(lock::writeLock).get();
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)1, (int)obj.get());
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)2, (int)obj.get());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testBuilderReadWriteLockVisitor(boolean fair) {
        AtomicInteger obj = new AtomicInteger();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(fair);
        LockingVisitors.ReadWriteLockVisitor lockVisitor = ((LockingVisitors.ReadWriteLockVisitor.Builder)LockingVisitors.ReadWriteLockVisitor.builder().setObject((Object)obj)).setLock((ReadWriteLock)lock).get();
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)1, (int)obj.get());
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)2, (int)obj.get());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testBuilderReentrantLockVisitor(boolean fair) {
        AtomicInteger obj = new AtomicInteger();
        ReentrantLock lock = new ReentrantLock(fair);
        LockingVisitors.ReentrantLockVisitor lockVisitor = ((LockingVisitors.ReentrantLockVisitor.Builder)LockingVisitors.ReentrantLockVisitor.builder().setObject((Object)obj)).setLock(lock).get();
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)1, (int)obj.get());
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)2, (int)obj.get());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testBuilderReentrantReadWriteLockVisitor(boolean fair) {
        AtomicInteger obj = new AtomicInteger();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(fair);
        LockingVisitors.ReadWriteLockVisitor lockVisitor = ((LockingVisitors.ReadWriteLockVisitor.Builder)LockingVisitors.ReadWriteLockVisitor.builder().setObject((Object)obj)).setLock((ReadWriteLock)lock).get();
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)1, (int)obj.get());
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)2, (int)obj.get());
    }

    @Test
    void testBuilderReentrantStampedLockVisitor() {
        AtomicInteger obj = new AtomicInteger();
        StampedLock lock = new StampedLock();
        LockingVisitors.StampedLockVisitor lockVisitor = ((LockingVisitors.StampedLockVisitor.Builder)LockingVisitors.StampedLockVisitor.builder().setObject((Object)obj)).setLock(lock).get();
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)1, (int)obj.get());
        lockVisitor.acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)2, (int)obj.get());
    }

    @Test
    void testCreate() {
        AtomicInteger obj = new AtomicInteger();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        LockingVisitors.create((Object)obj, (ReadWriteLock)lock).acceptReadLocked(AtomicInteger::incrementAndGet);
        LockingVisitors.create((Object)obj, (ReadWriteLock)lock).acceptReadLocked(null);
        Assertions.assertEquals((int)1, (int)obj.get());
        LockingVisitors.create((Object)obj, (ReadWriteLock)lock).acceptWriteLocked(AtomicInteger::incrementAndGet);
        LockingVisitors.create((Object)obj, (ReadWriteLock)lock).acceptWriteLocked(null);
        Assertions.assertEquals((int)2, (int)obj.get());
    }

    @Test
    void testDeprecatedConstructor() {
        Assertions.assertNotNull((Object)new LockingVisitors().toString());
    }

    @Test
    void testReentrantLock() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, false, millis -> Assertions.assertTrue((millis < TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.reentrantLockVisitor((Object)booleanValues));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testReentrantLockFairness(boolean fairness) throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, false, millis -> Assertions.assertTrue((millis < TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.create((Object)booleanValues, (ReentrantLock)new ReentrantLock(fairness)));
    }

    @Test
    void testReentrantReadWriteLockExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, true, millis -> Assertions.assertTrue((millis >= TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.reentrantReadWriteLockVisitor((Object)booleanValues));
    }

    @Test
    void testReentrantReadWriteLockNotExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, false, millis -> Assertions.assertTrue((millis < TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.reentrantReadWriteLockVisitor((Object)booleanValues));
    }

    @Test
    void testResultValidation() {
        Object hidden = new Object();
        LockingVisitors.StampedLockVisitor lock = LockingVisitors.stampedLockVisitor((Object)hidden);
        Object o1 = lock.applyReadLocked(h -> new Object());
        Assertions.assertNotNull((Object)o1);
        Assertions.assertNotSame((Object)hidden, (Object)o1);
        Object o2 = lock.applyWriteLocked(h -> new Object());
        Assertions.assertNotNull((Object)o2);
        Assertions.assertNotSame((Object)hidden, (Object)o2);
    }

    @Test
    void testStampedLockExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, true, millis -> Assertions.assertTrue((millis >= TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.stampedLockVisitor((Object)booleanValues));
    }

    @Test
    void testStampedLockNotExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, false, millis -> Assertions.assertTrue((millis < TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.stampedLockVisitor((Object)booleanValues));
    }
}

