/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.fitting;

import java.util.Collection;
import java.util.List;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.function.Gaussian;
import org.apache.commons.math4.legacy.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.fitting.SimpleCurveFitter;
import org.apache.commons.math4.legacy.fitting.WeightedObservedPoint;

public final class GaussianCurveFitter
extends SimpleCurveFitter {
    private static final Gaussian.Parametric FUNCTION = new Gaussian.Parametric(){

        @Override
        public double value(double x, double ... p) {
            double v = Double.POSITIVE_INFINITY;
            try {
                v = super.value(x, p);
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                // empty catch block
            }
            return v;
        }

        @Override
        public double[] gradient(double x, double ... p) {
            double[] v = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
            try {
                v = super.gradient(x, p);
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                // empty catch block
            }
            return v;
        }
    };

    private GaussianCurveFitter(double[] initialGuess, int maxIter) {
        super(FUNCTION, initialGuess, new ParameterGuesser(), maxIter);
    }

    public static GaussianCurveFitter create() {
        return new GaussianCurveFitter(null, Integer.MAX_VALUE);
    }

    public static class ParameterGuesser
    extends SimpleCurveFitter.ParameterGuesser {
        @Override
        public double[] guess(Collection<WeightedObservedPoint> observations) {
            if (observations == null) {
                throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
            }
            if (observations.size() < 3) {
                throw new NumberIsTooSmallException((Number)observations.size(), (Number)3, true);
            }
            List<WeightedObservedPoint> sorted = this.sortObservations(observations);
            return this.basicGuess(sorted.toArray(new WeightedObservedPoint[0]));
        }

        private double[] basicGuess(WeightedObservedPoint[] points) {
            double fwhmApprox;
            int maxYIdx = this.findMaxY(points);
            double n = points[maxYIdx].getY();
            try {
                double halfY = 0.5 * n;
                double fwhmX1 = this.interpolateXAtY(points, maxYIdx, -1, halfY);
                double fwhmX2 = this.interpolateXAtY(points, maxYIdx, 1, halfY);
                fwhmApprox = fwhmX2 - fwhmX1;
            }
            catch (OutOfRangeException e) {
                fwhmApprox = points[points.length - 1].getX() - points[0].getX();
            }
            double s = fwhmApprox / (2.0 * JdkMath.sqrt((double)(2.0 * JdkMath.log((double)2.0))));
            return new double[]{n, points[maxYIdx].getX(), s};
        }
    }
}

