/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.PathResolver;

public class URLResolver
implements PathResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog((Class)PathResolver.class);
    private URL baseURL = null;

    public URLResolver(URL baseURL) {
        this.baseURL = baseURL;
    }

    public String resolvePath(String ctxPath) {
        try {
            URL combined = new URL(this.baseURL, ctxPath);
            return combined.toString();
        }
        catch (MalformedURLException e) {
            this.log.error((Object)"Malformed URL", (Throwable)e);
            return null;
        }
    }

    public PathResolver getResolver(String ctxPath) {
        try {
            URL combined = new URL(this.baseURL, ctxPath);
            return new URLResolver(combined);
        }
        catch (MalformedURLException e) {
            this.log.error((Object)"Malformed URL", (Throwable)e);
            return null;
        }
    }
}

