/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.spi.loaderwriter;

import java.util.HashSet;
import java.util.Set;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterProviderConfiguration;
import org.ehcache.impl.internal.classes.ClassInstanceProvider;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterConfiguration;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterProvider;

public class DefaultCacheLoaderWriterProvider
extends ClassInstanceProvider<String, DefaultCacheLoaderWriterConfiguration, CacheLoaderWriter<?, ?>>
implements CacheLoaderWriterProvider {
    private final Set<String> cachesWithJsrRegisteredLoaders = new HashSet<String>();

    public DefaultCacheLoaderWriterProvider(DefaultCacheLoaderWriterProviderConfiguration configuration) {
        super(configuration, DefaultCacheLoaderWriterConfiguration.class, true);
    }

    @Override
    public <K, V> CacheLoaderWriter<? super K, V> createCacheLoaderWriter(String alias, CacheConfiguration<K, V> cacheConfiguration) {
        return (CacheLoaderWriter)this.newInstance(alias, cacheConfiguration);
    }

    @Override
    public void releaseCacheLoaderWriter(String alias, CacheLoaderWriter<?, ?> cacheLoaderWriter) throws Exception {
        this.releaseInstance(cacheLoaderWriter);
    }

    @Override
    public CacheLoaderWriterConfiguration<?> getPreConfiguredCacheLoaderWriterConfig(String alias) {
        return (CacheLoaderWriterConfiguration)this.getPreconfigured(alias);
    }

    @Override
    public boolean isLoaderJsrProvided(String alias) {
        return this.cachesWithJsrRegisteredLoaders.contains(alias);
    }

    protected void registerJsrLoaderForCache(String alias) {
        this.cachesWithJsrRegisteredLoaders.add(alias);
    }

    protected void deregisterJsrLoaderForCache(String alias) {
        this.cachesWithJsrRegisteredLoaders.remove(alias);
    }
}

