/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class CreateSessionMessage
extends PacketImpl {
    private String name;
    private long sessionChannelID;
    private int version;
    private String username;
    private String password;
    private int minLargeMessageSize;
    private boolean xa;
    private boolean autoCommitSends;
    private boolean autoCommitAcks;
    private boolean preAcknowledge;
    private int windowSize;
    private String defaultAddress;

    public CreateSessionMessage(String name, long sessionChannelID, int version, String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int windowSize, String defaultAddress) {
        this(30, name, sessionChannelID, version, username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge, windowSize, defaultAddress);
    }

    protected CreateSessionMessage(byte type, String name, long sessionChannelID, int version, String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int windowSize, String defaultAddress) {
        super(type);
        this.name = name;
        this.sessionChannelID = sessionChannelID;
        this.version = version;
        this.username = username;
        this.password = password;
        this.minLargeMessageSize = minLargeMessageSize;
        this.xa = xa;
        this.autoCommitSends = autoCommitSends;
        this.autoCommitAcks = autoCommitAcks;
        this.windowSize = windowSize;
        this.preAcknowledge = preAcknowledge;
        this.defaultAddress = defaultAddress;
    }

    public CreateSessionMessage() {
        super((byte)30);
    }

    protected CreateSessionMessage(byte type) {
        super(type);
    }

    public String getName() {
        return this.name;
    }

    public long getSessionChannelID() {
        return this.sessionChannelID;
    }

    public int getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isXA() {
        return this.xa;
    }

    public boolean isAutoCommitSends() {
        return this.autoCommitSends;
    }

    public boolean isAutoCommitAcks() {
        return this.autoCommitAcks;
    }

    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public String getDefaultAddress() {
        return this.defaultAddress;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeLong(this.sessionChannelID);
        buffer.writeInt(this.version);
        buffer.writeNullableString(this.username);
        buffer.writeNullableString(this.password);
        buffer.writeInt(this.minLargeMessageSize);
        buffer.writeBoolean(this.xa);
        buffer.writeBoolean(this.autoCommitSends);
        buffer.writeBoolean(this.autoCommitAcks);
        buffer.writeInt(this.windowSize);
        buffer.writeBoolean(this.preAcknowledge);
        buffer.writeNullableString(this.defaultAddress);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        this.sessionChannelID = buffer.readLong();
        this.version = buffer.readInt();
        this.username = buffer.readNullableString();
        this.password = buffer.readNullableString();
        this.minLargeMessageSize = buffer.readInt();
        this.xa = buffer.readBoolean();
        this.autoCommitSends = buffer.readBoolean();
        this.autoCommitAcks = buffer.readBoolean();
        this.windowSize = buffer.readInt();
        this.preAcknowledge = buffer.readBoolean();
        this.defaultAddress = buffer.readNullableString();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.autoCommitAcks ? 1231 : 1237);
        result = 31 * result + (this.autoCommitSends ? 1231 : 1237);
        result = 31 * result + (this.defaultAddress == null ? 0 : this.defaultAddress.hashCode());
        result = 31 * result + this.minLargeMessageSize;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.preAcknowledge ? 1231 : 1237);
        result = 31 * result + (int)(this.sessionChannelID ^ this.sessionChannelID >>> 32);
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + this.version;
        result = 31 * result + this.windowSize;
        result = 31 * result + (this.xa ? 1231 : 1237);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", autoCommitAcks=" + this.autoCommitAcks);
        sb.append(", autoCommitSends=" + this.autoCommitSends);
        sb.append(", defaultAddress=" + this.defaultAddress);
        sb.append(", minLargeMessageSize=" + this.minLargeMessageSize);
        sb.append(", name=" + this.name);
        sb.append(", password=****");
        sb.append(", preAcknowledge=" + this.preAcknowledge);
        sb.append(", sessionChannelID=" + this.sessionChannelID);
        sb.append(", username=" + this.username);
        sb.append(", version=" + this.version);
        sb.append(", windowSize=" + this.windowSize);
        sb.append(", xa=" + this.xa);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSessionMessage)) {
            return false;
        }
        CreateSessionMessage other = (CreateSessionMessage)obj;
        if (this.autoCommitAcks != other.autoCommitAcks) {
            return false;
        }
        if (this.autoCommitSends != other.autoCommitSends) {
            return false;
        }
        if (this.defaultAddress == null ? other.defaultAddress != null : !this.defaultAddress.equals(other.defaultAddress)) {
            return false;
        }
        if (this.minLargeMessageSize != other.minLargeMessageSize) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.preAcknowledge != other.preAcknowledge) {
            return false;
        }
        if (this.sessionChannelID != other.sessionChannelID) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        if (this.windowSize != other.windowSize) {
            return false;
        }
        return this.xa == other.xa;
    }
}

