/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.activemq.artemis.core.remoting.impl.ssl.CachingSSLContextFactory;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextFactory;
import org.apache.activemq.artemis.spi.core.security.jaas.LDAPLoginModule;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

public class LDAPLoginSSLSocketFactory
extends SocketFactory {
    private static final String KEYSTORE_PROVIDER = "keystoreProvider";
    private static final String KEYSTORE_TYPE = "keystoreType";
    private static final String KEYSTORE_PATH = "keystorePath";
    private static final String KEYSTORE_PASSWORD = "keystorePassword";
    private static final String KEYSTORE_ALIAS = "keystoreAlias";
    private static final String TRUSTSTORE_PROVIDER = "truststoreProvider";
    private static final String TRUSTSTORE_TYPE = "truststoreType";
    private static final String TRUSTSTORE_PATH = "truststorePath";
    private static final String TRUSTSTORE_PASSWORD = "truststorePassword";
    private static final String CRL_PATH = "crlPath";
    private static final String TRUST_ALL = "trustAll";
    private static final String TRUST_MANAGER_FACTORY_PLUGIN = "trustManagerFactoryPlugin";
    private static final String CRC_OPTIONS = "crcOptions";
    private static final String OCSP_RESPONDER_URL = "ocspResponderURL";
    private static final SSLContextFactory sslContextFactory = new CachingSSLContextFactory();
    private final String codecClass;
    private final Map<String, String> environment;
    private SSLSocketFactory sslSocketFactory;

    protected static SSLContextFactory getSSLContextFactory() {
        return sslContextFactory;
    }

    public static LDAPLoginSSLSocketFactory getDefault() {
        return new LDAPLoginSSLSocketFactory();
    }

    public LDAPLoginSSLSocketFactory() {
        this(LDAPLoginModule.getEnvironment());
    }

    public LDAPLoginSSLSocketFactory(Map<String, String> environment) {
        Objects.requireNonNull(environment, "LDAPLoginModule environment is null");
        this.environment = environment;
        this.codecClass = environment.get(LDAPLoginModule.ConfigKey.PASSWORD_CODEC.getName());
    }

    protected void loadSSLSocketFactory() {
        SSLContext sslContext = this.getSSLContext();
        this.sslSocketFactory = sslContext.getSocketFactory();
    }

    protected SSLContext getSSLContext() {
        SSLContextConfig sslContextConfig = this.getSSLContextConfig();
        try {
            return sslContextFactory.getSSLContext(sslContextConfig, Collections.unmodifiableMap(this.environment));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error getting the ssl context", e);
        }
    }

    protected SSLContextConfig getSSLContextConfig() {
        SSLContextConfig.Builder sslContextConfigBuilder = SSLContextConfig.builder();
        if (this.environment.containsKey(KEYSTORE_PROVIDER)) {
            sslContextConfigBuilder.keystoreProvider(this.environment.get(KEYSTORE_PROVIDER));
        }
        if (this.environment.containsKey(KEYSTORE_TYPE)) {
            sslContextConfigBuilder.keystoreType(this.environment.get(KEYSTORE_TYPE));
        }
        if (this.environment.containsKey(KEYSTORE_PATH)) {
            sslContextConfigBuilder.keystorePath(this.environment.get(KEYSTORE_PATH));
        }
        if (this.environment.containsKey(KEYSTORE_PASSWORD)) {
            sslContextConfigBuilder.keystorePassword(this.getSensitiveText(KEYSTORE_PASSWORD));
        }
        if (this.environment.containsKey(KEYSTORE_ALIAS)) {
            sslContextConfigBuilder.keystoreAlias(this.environment.get(KEYSTORE_ALIAS));
        }
        if (this.environment.containsKey(TRUSTSTORE_PROVIDER)) {
            sslContextConfigBuilder.truststoreProvider(this.environment.get(TRUSTSTORE_PROVIDER));
        }
        if (this.environment.containsKey(TRUSTSTORE_TYPE)) {
            sslContextConfigBuilder.truststoreType(this.environment.get(TRUSTSTORE_TYPE));
        }
        if (this.environment.containsKey(TRUSTSTORE_PATH)) {
            sslContextConfigBuilder.truststorePath(this.environment.get(TRUSTSTORE_PATH));
        }
        if (this.environment.containsKey(TRUSTSTORE_PASSWORD)) {
            sslContextConfigBuilder.truststorePassword(this.getSensitiveText(TRUSTSTORE_PASSWORD));
        }
        if (this.environment.containsKey(CRL_PATH)) {
            sslContextConfigBuilder.crlPath(this.environment.get(CRL_PATH));
        }
        if (this.environment.containsKey(TRUST_ALL)) {
            sslContextConfigBuilder.trustAll(Boolean.parseBoolean(this.environment.get(TRUST_ALL)));
        }
        if (this.environment.containsKey(TRUST_MANAGER_FACTORY_PLUGIN)) {
            sslContextConfigBuilder.trustManagerFactoryPlugin(this.environment.get(TRUST_MANAGER_FACTORY_PLUGIN));
        }
        if (this.environment.containsKey(CRC_OPTIONS)) {
            sslContextConfigBuilder.crcOptions(this.environment.get(CRC_OPTIONS));
        }
        if (this.environment.containsKey(OCSP_RESPONDER_URL)) {
            sslContextConfigBuilder.ocspResponderURL(this.environment.get(OCSP_RESPONDER_URL));
        }
        return sslContextConfigBuilder.build();
    }

    protected String getSensitiveText(String key) {
        try {
            String text = this.environment.get(key);
            return PasswordMaskingUtil.resolveMask((String)text, (String)this.codecClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse sensitive text " + key, e);
        }
    }

    private void checkSSLSocketFactory() {
        if (this.sslSocketFactory == null) {
            this.loadSSLSocketFactory();
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        this.checkSSLSocketFactory();
        return this.sslSocketFactory.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        this.checkSSLSocketFactory();
        return this.sslSocketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        this.checkSSLSocketFactory();
        return this.sslSocketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        this.checkSSLSocketFactory();
        return this.sslSocketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        this.checkSSLSocketFactory();
        return this.sslSocketFactory.createSocket(address, port, localAddress, localPort);
    }
}

