/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries.helper;

import java.util.HashSet;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaErrorHandler;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttributeTypeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeTypeHelper.class);

    private AttributeTypeHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(AttributeType attributeType, SchemaErrorHandler errorHandler, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                attributeType.unlock();
                AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
                if (!AttributeTypeHelper.buildSuperior(attributeType, errorHandler, registries)) {
                    return;
                }
                AttributeTypeHelper.buildSyntax(attributeType, errorHandler, registries);
                AttributeTypeHelper.buildEquality(attributeType, errorHandler, registries);
                AttributeTypeHelper.buildOrdering(attributeType, errorHandler, registries);
                AttributeTypeHelper.buildSubstring(attributeType, errorHandler, registries);
                AttributeTypeHelper.checkUsage(attributeType, errorHandler);
                AttributeTypeHelper.checkCollective(attributeType, errorHandler);
                attributeTypeRegistry.addMappingFor(attributeType);
                attributeTypeRegistry.registerDescendants(attributeType, attributeType.getSuperior());
                if (attributeType.getEquality() != null) {
                    registries.addReference(attributeType, attributeType.getEquality());
                }
                if (attributeType.getOrdering() != null) {
                    registries.addReference(attributeType, attributeType.getOrdering());
                }
                if (attributeType.getSubstring() != null) {
                    registries.addReference(attributeType, attributeType.getSubstring());
                }
                if (attributeType.getSyntax() != null) {
                    registries.addReference(attributeType, attributeType.getSyntax());
                }
                if (attributeType.getSuperior() != null) {
                    registries.addReference(attributeType, attributeType.getSuperior());
                }
            }
            finally {
                attributeType.lock();
            }
        }
    }

    private static boolean buildSuperior(AttributeType attributeType, SchemaErrorHandler errorHandler, Registries registries) {
        AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
        String superiorOid = attributeType.getSuperiorOid();
        if (superiorOid != null) {
            AttributeType currentSuperior;
            try {
                currentSuperior = (AttributeType)attributeTypeRegistry.lookup(superiorOid);
            }
            catch (Exception e) {
                String msg = I18n.err((I18n)I18n.ERR_13752_CANNOT_FIND_SUPERIOR, (Object[])new Object[]{superiorOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SUPERIOR, msg, e);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(superiorOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
                return false;
            }
            if (currentSuperior != null) {
                if (currentSuperior.isCollective()) {
                    String msg = I18n.err((I18n)I18n.ERR_13776_CANNOT_SUBTYPE_COLLECTIVE, (Object[])new Object[]{currentSuperior, attributeType.getName()});
                    LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_CANNOT_SUBTYPE_COLLECTIVE_AT, msg);
                    ldapSchemaException.setSourceObject(attributeType);
                    errorHandler.handle(LOG, msg, ldapSchemaException);
                    return false;
                }
                attributeType.setSuperior(currentSuperior);
                if (currentSuperior.getSuperior() == null) {
                    registries.buildReference(currentSuperior);
                }
                try {
                    attributeTypeRegistry.registerDescendants(attributeType, currentSuperior);
                }
                catch (LdapException ne) {
                    errorHandler.handle(LOG, ne.getMessage(), ne);
                    return false;
                }
                HashSet<String> superiors = new HashSet<String>();
                superiors.add(attributeType.getOid());
                boolean isOk = true;
                for (AttributeType tmp = currentSuperior; tmp != null; tmp = tmp.getSuperior()) {
                    if (superiors.contains(tmp.getOid())) {
                        String msg = I18n.err((I18n)I18n.ERR_13753_CYCLE_DETECTED, (Object[])new Object[]{attributeType.getName()});
                        LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_CYCLE_TYPE_HIERARCHY, msg);
                        ldapSchemaException.setSourceObject(attributeType);
                        errorHandler.handle(LOG, msg, ldapSchemaException);
                        isOk = false;
                        break;
                    }
                    superiors.add(tmp.getOid());
                }
                superiors.clear();
                return isOk;
            }
            String msg = I18n.err((I18n)I18n.ERR_13752_CANNOT_FIND_SUPERIOR, (Object[])new Object[]{superiorOid, attributeType.getName()});
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SUPERIOR, msg);
            ldapSchemaException.setSourceObject(attributeType);
            ldapSchemaException.setRelatedId(superiorOid);
            errorHandler.handle(LOG, msg, ldapSchemaException);
            return false;
        }
        return true;
    }

    private static void buildSyntax(AttributeType attributeType, SchemaErrorHandler errorHandler, Registries registries) {
        String syntaxOid = attributeType.getSyntaxOid();
        if (syntaxOid != null) {
            LdapSyntax currentSyntax = null;
            try {
                currentSyntax = (LdapSyntax)registries.getLdapSyntaxRegistry().lookup(syntaxOid);
            }
            catch (LdapException ne) {
                String msg = I18n.err((I18n)I18n.ERR_13754_CANNOT_FIND_SYNTAX, (Object[])new Object[]{syntaxOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SYNTAX, msg, ne);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(syntaxOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
                return;
            }
            if (currentSyntax != null) {
                attributeType.setSyntax(currentSyntax);
            } else {
                String msg = I18n.err((I18n)I18n.ERR_13754_CANNOT_FIND_SYNTAX, (Object[])new Object[]{syntaxOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SYNTAX, msg);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(syntaxOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
            }
        } else if (attributeType.getSuperior() != null) {
            if (attributeType.getSuperior().getSyntax() != null) {
                attributeType.setSyntax(attributeType.getSuperior().getSyntax());
            } else {
                String msg = I18n.err((I18n)I18n.ERR_13754_CANNOT_FIND_SYNTAX, (Object[])new Object[]{syntaxOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SYNTAX, msg);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(syntaxOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
            }
        } else {
            String msg = I18n.err((I18n)I18n.ERR_13755_AT_MUST_HAVE_A_SYNTAX_OID, (Object[])new Object[]{attributeType.getName()});
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_SYNTAX_OR_SUPERIOR_REQUIRED, msg);
            ldapSchemaException.setSourceObject(attributeType);
            errorHandler.handle(LOG, msg, ldapSchemaException);
        }
    }

    private static void buildEquality(AttributeType attributeType, SchemaErrorHandler errorHandler, Registries registries) {
        String equalityOid = attributeType.getEqualityOid();
        if (equalityOid != null) {
            MatchingRule currentEquality = null;
            try {
                currentEquality = (MatchingRule)registries.getMatchingRuleRegistry().lookup(equalityOid);
            }
            catch (LdapException ne) {
                String msg = I18n.err((I18n)I18n.ERR_13756_CANNOT_FIND_EQUALITY_MR_OBJECT, (Object[])new Object[]{equalityOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_EQUALITY_MATCHING_RULE, msg, ne);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(equalityOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
                return;
            }
            if (currentEquality != null) {
                attributeType.setEquality(currentEquality);
                attributeType.setEqualityOid(equalityOid);
            } else {
                String msg = I18n.err((I18n)I18n.ERR_13757_CANNOT_FIND_EQUALITY_MR_INSTANCE, (Object[])new Object[]{equalityOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_EQUALITY_MATCHING_RULE, msg);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(equalityOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
            }
        } else {
            AttributeType superior = attributeType.getSuperior();
            if (superior != null && superior.getEquality() != null) {
                attributeType.setEquality(superior.getEquality());
            }
        }
    }

    private static void buildSubstring(AttributeType attributeType, SchemaErrorHandler errorHandler, Registries registries) {
        String substringOid = attributeType.getSubstringOid();
        if (substringOid != null) {
            MatchingRule currentSubstring = null;
            try {
                currentSubstring = (MatchingRule)registries.getMatchingRuleRegistry().lookup(substringOid);
            }
            catch (LdapException ne) {
                String msg = I18n.err((I18n)I18n.ERR_13760_CANNOT_FIND_SUBSTR_MR_OBJECT, (Object[])new Object[]{substringOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SUBSTRING_MATCHING_RULE, msg, ne);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(substringOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
                return;
            }
            if (currentSubstring != null) {
                attributeType.setSubstring(currentSubstring);
            } else {
                String msg = I18n.err((I18n)I18n.ERR_13761_CANNOT_FIND_SUBSTR_MR_INSTANCE, (Object[])new Object[]{substringOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_SUBSTRING_MATCHING_RULE, msg);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(substringOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
            }
        } else {
            AttributeType superior = attributeType.getSuperior();
            if (superior != null && superior.getSubstring() != null) {
                attributeType.setSubstring(superior.getSubstring());
            }
        }
    }

    private static void buildOrdering(AttributeType attributeType, SchemaErrorHandler errorHandler, Registries registries) {
        String orderingOid = attributeType.getOrderingOid();
        if (orderingOid != null) {
            MatchingRule currentOrdering = null;
            try {
                currentOrdering = (MatchingRule)registries.getMatchingRuleRegistry().lookup(orderingOid);
            }
            catch (LdapException ne) {
                String msg = I18n.err((I18n)I18n.ERR_13758_CANNOT_FIND_ORDERING_MR_OBJECT, (Object[])new Object[]{orderingOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_ORDERING_MATCHING_RULE, msg, ne);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(orderingOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
                return;
            }
            if (currentOrdering != null) {
                attributeType.setOrdering(currentOrdering);
            } else {
                String msg = I18n.err((I18n)I18n.ERR_13759_CANNOT_FIND_ORDERING_MR_INSTANCE, (Object[])new Object[]{orderingOid, attributeType.getName()});
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_NONEXISTENT_ORDERING_MATCHING_RULE, msg);
                ldapSchemaException.setSourceObject(attributeType);
                ldapSchemaException.setRelatedId(orderingOid);
                errorHandler.handle(LOG, msg, ldapSchemaException);
            }
        } else {
            AttributeType superior = attributeType.getSuperior();
            if (superior != null && superior.getOrdering() != null) {
                attributeType.setOrdering(superior.getOrdering());
            }
        }
    }

    private static void checkUsage(AttributeType attributeType, SchemaErrorHandler errorHandler) {
        AttributeType superior = attributeType.getSuperior();
        if (superior != null && attributeType.getUsage() != superior.getUsage()) {
            String msg = I18n.err((I18n)I18n.ERR_13762_AT_MUST_HAVE_SUPERIOR_USAGE, (Object[])new Object[]{attributeType.getName()});
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_MUST_HAVE_SAME_USAGE_THAN_SUPERIOR, msg);
            ldapSchemaException.setSourceObject(attributeType);
            errorHandler.handle(LOG, msg, ldapSchemaException);
            return;
        }
        if (!attributeType.isUserModifiable() && attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) {
            String msg = I18n.err((I18n)I18n.ERR_13763_AT_MUST_BE_USER_MODIFIABLE, (Object[])new Object[]{attributeType.getName()});
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_USER_APPLICATIONS_USAGE_MUST_BE_USER_MODIFIABLE, msg);
            ldapSchemaException.setSourceObject(attributeType);
            errorHandler.handle(LOG, msg, ldapSchemaException);
        }
    }

    private static void checkCollective(AttributeType attributeType, SchemaErrorHandler errorHandler) {
        LdapSchemaException ldapSchemaException;
        String msg;
        AttributeType superior = attributeType.getSuperior();
        if (superior != null && superior.isCollective()) {
            attributeType.setCollective(true);
        }
        if (attributeType.isCollective() && attributeType.getUsage() != UsageEnum.USER_APPLICATIONS) {
            msg = I18n.err((I18n)I18n.ERR_13764_AT_COLLECTIVE_SHOULD_BE_USER_APP, (Object[])new Object[]{attributeType.getName()});
            ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_COLLECTIVE_MUST_HAVE_USER_APPLICATIONS_USAGE, msg);
            ldapSchemaException.setSourceObject(attributeType);
            errorHandler.handle(LOG, msg, ldapSchemaException);
        }
        if (attributeType.isCollective() && attributeType.isSingleValued()) {
            msg = I18n.err((I18n)I18n.ERR_13777_COLLECTIVE_NOT_MULTI_VALUED, (Object[])new Object[]{attributeType.getName()});
            ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.AT_COLLECTIVE_CANNOT_BE_SINGLE_VALUED, msg);
            ldapSchemaException.setSourceObject(attributeType);
            errorHandler.handle(LOG, msg, ldapSchemaException);
        }
    }

    public static void removeFromRegistries(AttributeType attributeType, SchemaErrorHandler errorHandler, Registries registries) throws LdapException {
        if (registries != null) {
            AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
            attributeTypeRegistry.removeMappingFor(attributeType);
            attributeTypeRegistry.unregisterDescendants(attributeType, attributeType.getSuperior());
            if (attributeType.getEquality() != null) {
                registries.delReference(attributeType, attributeType.getEquality());
            }
            if (attributeType.getOrdering() != null) {
                registries.delReference(attributeType, attributeType.getOrdering());
            }
            if (attributeType.getSubstring() != null) {
                registries.delReference(attributeType, attributeType.getSubstring());
            }
            if (attributeType.getSyntax() != null) {
                registries.delReference(attributeType, attributeType.getSyntax());
            }
            if (attributeType.getSuperior() != null) {
                registries.delReference(attributeType, attributeType.getSuperior());
            }
        }
    }
}

