/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.actions;

import org.apache.directory.studio.ldapservers.LdapServersPluginConstants;
import org.apache.directory.studio.ldapservers.actions.Messages;
import org.apache.directory.studio.ldapservers.jobs.OpenConfigurationLdapServerRunnable;
import org.apache.directory.studio.ldapservers.jobs.StudioLdapServerJob;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.views.ServersView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenConfigurationAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;

    public OpenConfigurationAction() {
        super(Messages.getString("OpenConfigurationAction.OpenConfiguration"));
        this.init();
    }

    public OpenConfigurationAction(ServersView view) {
        super(Messages.getString("OpenConfigurationAction.OpenConfiguration"));
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(LdapServersPluginConstants.CMD_OPEN_CONFIGURATION);
        this.setActionDefinitionId(LdapServersPluginConstants.CMD_OPEN_CONFIGURATION);
        this.setToolTipText(Messages.getString("OpenConfigurationAction.OpenConfigurationToolTip"));
    }

    public void run() {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty() && selection.size() == 1) {
            LdapServer server = (LdapServer)selection.getFirstElement();
            StudioLdapServerJob job = new StudioLdapServerJob(new OpenConfigurationLdapServerRunnable(server));
            job.schedule();
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

