/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.blueprint.BlueprintStateMBean;
import org.apache.aries.jmx.blueprint.codec.OSGiBlueprintEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;

public class BlueprintState
implements BlueprintStateMBean,
MBeanRegistration {
    private BundleContext context;
    private ServiceRegistration listenerReg;
    private Map<Long, CompositeData> dataMap = new HashMap<Long, CompositeData>();

    public BlueprintState(BundleContext context) {
        this.context = context;
    }

    public synchronized long[] getBlueprintBundleIds() throws IOException {
        Long[] bundleIdKeys = this.dataMap.keySet().toArray(new Long[0]);
        long[] bundleIds = new long[bundleIdKeys.length];
        for (int i = 0; i < bundleIdKeys.length; ++i) {
            bundleIds[i] = bundleIdKeys[i];
        }
        return bundleIds;
    }

    public synchronized CompositeData getLastEvent(long bundleId) throws IOException {
        return this.dataMap.get(bundleId);
    }

    public synchronized TabularData getLastEvents() throws IOException {
        TabularDataSupport table = new TabularDataSupport(BlueprintStateMBean.OSGI_BLUEPRINT_EVENTS_TYPE);
        table.putAll(this.dataMap);
        return table;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        BlueprintStateListener listener = new BlueprintStateListener();
        this.listenerReg = this.context.registerService(BlueprintListener.class.getName(), (Object)listener, null);
    }

    public void preDeregister() throws Exception {
        try {
            this.listenerReg.unregister();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postDeregister() {
    }

    private class BlueprintStateListener
    implements BlueprintListener {
        private BlueprintStateListener() {
        }

        public synchronized void blueprintEvent(BlueprintEvent event) {
            CompositeData data = new OSGiBlueprintEvent(event).asCompositeData();
            BlueprintState.this.dataMap.put(event.getBundle().getBundleId(), data);
        }
    }
}

