/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.store.mapper;

import java.io.File;
import org.apache.felix.ipojo.manipulator.store.ResourceMapper;

public class FileSystemResourceMapper
implements ResourceMapper {
    private ResourceMapper m_delegate;
    private char m_separator;

    public FileSystemResourceMapper(ResourceMapper delegate) {
        this(delegate, File.separatorChar);
    }

    public FileSystemResourceMapper(ResourceMapper delegate, char separator) {
        this.m_delegate = delegate;
        this.m_separator = separator;
    }

    @Override
    public String internalize(String name) {
        return this.systemPath(this.m_delegate.internalize(name));
    }

    @Override
    public String externalize(String name) {
        return this.m_delegate.externalize(this.normalizePath(name));
    }

    private String normalizePath(String path) {
        return path.replace(this.m_separator, '/');
    }

    private String systemPath(String path) {
        return path.replace('/', this.m_separator);
    }
}

