/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.upnp.internal;

import org.apache.felix.webconsole.plugins.upnp.internal.SessionObject;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPLocalStateVariable;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;

class Serializer {
    private Serializer() {
    }

    static final JSONObject deviceToJSON(ServiceReference ref, UPnPDevice device) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("icon", device.getIcons(null) != null);
        String[] props = ref.getPropertyKeys();
        JSONObject _props = new JSONObject();
        for (int i = 0; props != null && i < props.length; ++i) {
            _props.put(props[i], ref.getProperty(props[i]));
        }
        json.put("props", (Object)_props);
        UPnPService[] services = device.getServices();
        for (int i = 0; services != null && i < services.length; ++i) {
            json.append("services", (Object)services[i].getType());
        }
        return json;
    }

    static final JSONObject serviceToJSON(UPnPService service, SessionObject session) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("type", (Object)service.getType());
        json.put("id", (Object)service.getId());
        UPnPStateVariable[] vars = service.getStateVariables();
        for (int i = 0; vars != null && i < vars.length; ++i) {
            Object value = null;
            if (vars[i] instanceof UPnPLocalStateVariable) {
                value = ((UPnPLocalStateVariable)vars[i]).getCurrentValue();
            }
            if (value == null) {
                value = session.getValue(vars[i].getName());
            }
            if (value == null) {
                value = "---";
            }
            json.append("variables", (Object)Serializer.variableToJSON(vars[i], vars[i].getName()).put("value", value));
        }
        UPnPAction[] actions = service.getActions();
        for (int i = 0; actions != null && i < actions.length; ++i) {
            json.append("actions", (Object)Serializer.actionToJSON(actions[i]));
        }
        return json;
    }

    static final JSONObject variableToJSON(UPnPStateVariable var, String name) throws JSONException {
        return new JSONObject().put("name", (Object)name).put("default", var.getDefaultValue()).put("min", (Object)var.getMinimum()).put("max", (Object)var.getMaximum()).put("step", (Object)var.getStep()).put("allowed", (Object)var.getAllowedValues()).put("sendsEvents", var.sendsEvents()).put("type", (Object)var.getUPnPDataType());
    }

    static final JSONObject actionToJSON(UPnPAction action) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("name", (Object)action.getName());
        String[] names = action.getInputArgumentNames();
        for (int i = 0; names != null && i < names.length; ++i) {
            UPnPStateVariable variable = action.getStateVariable(names[i]);
            json.append("inVars", (Object)Serializer.variableToJSON(variable, names[i]));
        }
        return json;
    }
}

