/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.maven.osgicheck.impl.mddocgen;

import java.text.MessageFormat;
import org.apache.felix.scr.impl.helper.Logger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.maven.plugin.logging.Log;

final class MavenScrLogger
implements Logger {
    private final Log log;

    public MavenScrLogger(Log log) {
        this.log = log;
    }

    public boolean isLogEnabled(int level) {
        switch (level) {
            case 4: {
                return this.log.isDebugEnabled();
            }
            case 1: {
                return this.log.isErrorEnabled();
            }
            case 3: {
                return this.log.isInfoEnabled();
            }
            case 2: {
                return this.log.isWarnEnabled();
            }
        }
        return false;
    }

    public void log(int level, String pattern, Object[] arguments, ComponentMetadata metadata, Long componentId, Throwable ex) {
        String message = MessageFormat.format(pattern, arguments);
        this.log(level, message, metadata, componentId, ex);
    }

    public void log(int level, String message, ComponentMetadata metadata, Long componentId, Throwable ex) {
        switch (level) {
            case 4: {
                if (ex != null) {
                    this.log.debug((CharSequence)message, ex);
                    break;
                }
                this.log.debug((CharSequence)message);
                break;
            }
            case 1: {
                if (ex != null) {
                    this.log.error((CharSequence)message, ex);
                    break;
                }
                this.log.error((CharSequence)message);
                break;
            }
            case 3: {
                if (ex != null) {
                    this.log.info((CharSequence)message, ex);
                    break;
                }
                this.log.info((CharSequence)message);
                break;
            }
            case 2: {
                if (ex != null) {
                    this.log.warn((CharSequence)message, ex);
                    break;
                }
                this.log.warn((CharSequence)message);
                break;
            }
        }
    }
}

