/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.api.datastream.DataStream;

public class ReplayableDataStreamList {
    private final List<DataStream<?>> replayedDataStreams;
    private final List<DataStream<?>> nonReplayedStreams;

    private ReplayableDataStreamList(List<DataStream<?>> replayedDataStreams, List<DataStream<?>> nonReplayedStreams) {
        this.replayedDataStreams = replayedDataStreams;
        this.nonReplayedStreams = nonReplayedStreams;
    }

    public static ReplayedDataStreamList replay(DataStream<?> ... dataStreams) {
        return new ReplayedDataStreamList(Arrays.asList(dataStreams));
    }

    public static NonReplayedDataStreamList notReplay(DataStream<?> ... dataStreams) {
        return new NonReplayedDataStreamList(Arrays.asList(dataStreams));
    }

    List<DataStream<?>> getReplayedDataStreams() {
        return Collections.unmodifiableList(this.replayedDataStreams);
    }

    List<DataStream<?>> getNonReplayedStreams() {
        return Collections.unmodifiableList(this.nonReplayedStreams);
    }

    public static class NonReplayedDataStreamList
    extends ReplayableDataStreamList {
        public NonReplayedDataStreamList(List<DataStream<?>> nonReplayedDataStreams) {
            super(Collections.emptyList(), nonReplayedDataStreams);
        }
    }

    public static class ReplayedDataStreamList
    extends ReplayableDataStreamList {
        public ReplayedDataStreamList(List<DataStream<?>> replayedDataStreams) {
            super(replayedDataStreams, Collections.emptyList());
        }

        public ReplayableDataStreamList andNotReplay(DataStream<?> ... nonReplayedStreams) {
            return new ReplayableDataStreamList(this.getReplayedDataStreams(), Arrays.asList(nonReplayedStreams));
        }
    }
}

