/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification.naivebayes;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class NaiveBayesModelData {
    private static final Map<String, TypeInformation<?>> fields = new HashMap();
    public static final TypeInformation<NaiveBayesModelData> TYPE_INFO;
    public Map<Double, Double>[][] theta;
    public DenseVector piArray;
    public DenseVector labels;

    public NaiveBayesModelData(Map<Double, Double>[][] theta, DenseVector piArray, DenseVector labels) {
        this.theta = theta;
        this.piArray = piArray;
        this.labels = labels;
    }

    public NaiveBayesModelData() {
    }

    public static DataStream<NaiveBayesModelData> getModelDataStream(Table modelData) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelData).getTableEnvironment();
        return tEnv.toDataStream(modelData).map((MapFunction & Serializable)row -> new NaiveBayesModelData((Map[][])row.getField(0), ((Vector)row.getField(1)).toDense(), ((Vector)row.getField(2)).toDense()), TYPE_INFO);
    }

    static {
        fields.put("theta", Types.OBJECT_ARRAY((TypeInformation)Types.OBJECT_ARRAY((TypeInformation)Types.MAP((TypeInformation)Types.DOUBLE, (TypeInformation)Types.DOUBLE))));
        fields.put("piArray", DenseVectorTypeInfo.INSTANCE);
        fields.put("labels", DenseVectorTypeInfo.INSTANCE);
        TYPE_INFO = Types.POJO(NaiveBayesModelData.class, fields);
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<NaiveBayesModelData> {
        public StreamFormat.Reader<NaiveBayesModelData> createReader(Configuration config, final FSDataInputStream inputStream) {
            return new StreamFormat.Reader<NaiveBayesModelData>(){
                private final DenseVectorSerializer serializer = new DenseVectorSerializer();

                public NaiveBayesModelData read() throws IOException {
                    try {
                        DataInputViewStreamWrapper inputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)inputStream);
                        MapSerializer mapSerializer = new MapSerializer((TypeSerializer)DoubleSerializer.INSTANCE, (TypeSerializer)DoubleSerializer.INSTANCE);
                        DenseVector labels = this.serializer.deserialize((DataInputView)inputViewStreamWrapper);
                        DenseVector piArray = this.serializer.deserialize((DataInputView)inputViewStreamWrapper);
                        int featureSize = inputViewStreamWrapper.readInt();
                        int numLabels = inputViewStreamWrapper.readInt();
                        HashMap[][] theta = new HashMap[numLabels][featureSize];
                        for (int i = 0; i < featureSize; ++i) {
                            for (int j = 0; j < numLabels; ++j) {
                                theta[i][j] = mapSerializer.deserialize((DataInputView)inputViewStreamWrapper);
                            }
                        }
                        return new NaiveBayesModelData(theta, piArray, labels);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }

        public TypeInformation<NaiveBayesModelData> getProducedType() {
            return TYPE_INFO;
        }
    }

    public static class ModelDataEncoder
    implements Encoder<NaiveBayesModelData> {
        private final DenseVectorSerializer serializer = new DenseVectorSerializer();

        public void encode(NaiveBayesModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper outputViewStreamWrapper = new DataOutputViewStreamWrapper(outputStream);
            MapSerializer mapSerializer = new MapSerializer((TypeSerializer)DoubleSerializer.INSTANCE, (TypeSerializer)DoubleSerializer.INSTANCE);
            this.serializer.serialize(modelData.labels, (DataOutputView)outputViewStreamWrapper);
            this.serializer.serialize(modelData.piArray, (DataOutputView)outputViewStreamWrapper);
            outputViewStreamWrapper.writeInt(modelData.theta.length);
            outputViewStreamWrapper.writeInt(modelData.theta[0].length);
            Map<Double, Double>[][] mapArray = modelData.theta;
            int n = mapArray.length;
            for (int i = 0; i < n; ++i) {
                Map<Double, Double>[] maps;
                for (Map<Double, Double> map : maps = mapArray[i]) {
                    mapSerializer.serialize(map, (DataOutputView)outputViewStreamWrapper);
                }
            }
        }
    }
}

