/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.broadcast.operator;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.iteration.operator.OperatorWrapper;
import org.apache.flink.ml.common.broadcast.operator.OneInputBroadcastWrapperOperator;
import org.apache.flink.ml.common.broadcast.operator.TwoInputBroadcastWrapperOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

public class BroadcastWrapper<T>
implements OperatorWrapper<T, T> {
    private final String[] broadcastStreamNames;
    private final TypeInformation<?>[] inTypes;
    private final boolean[] isBlocked;

    @VisibleForTesting
    public BroadcastWrapper(String[] broadcastStreamNames, TypeInformation<?>[] inTypes) {
        this(broadcastStreamNames, inTypes, new boolean[inTypes.length]);
    }

    public BroadcastWrapper(String[] broadcastStreamNames, TypeInformation<?>[] inTypes, boolean[] isBlocked) {
        Preconditions.checkArgument((inTypes.length == isBlocked.length ? 1 : 0) != 0);
        this.broadcastStreamNames = broadcastStreamNames;
        this.inTypes = inTypes;
        this.isBlocked = isBlocked;
    }

    @Override
    public StreamOperator<T> wrap(StreamOperatorParameters<T> operatorParameters, StreamOperatorFactory<T> operatorFactory) {
        Class operatorClass = operatorFactory.getStreamOperatorClass(this.getClass().getClassLoader());
        if (OneInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return new OneInputBroadcastWrapperOperator(operatorParameters, operatorFactory, this.broadcastStreamNames, this.inTypes, this.isBlocked);
        }
        if (TwoInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return new TwoInputBroadcastWrapperOperator(operatorParameters, operatorFactory, this.broadcastStreamNames, this.inTypes, this.isBlocked);
        }
        throw new UnsupportedOperationException("Unsupported operator class for with-broadcast wrapper: " + operatorClass);
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader, StreamOperatorFactory<T> operatorFactory) {
        Class operatorClass = operatorFactory.getStreamOperatorClass(this.getClass().getClassLoader());
        if (OneInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return OneInputBroadcastWrapperOperator.class;
        }
        if (TwoInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return TwoInputBroadcastWrapperOperator.class;
        }
        throw new UnsupportedOperationException("Unsupported operator class for with-broadcast wrapper: " + operatorClass);
    }

    @Override
    public <KEY> KeySelector<T, KEY> wrapKeySelector(KeySelector<T, KEY> keySelector) {
        return keySelector;
    }

    @Override
    public StreamPartitioner<T> wrapStreamPartitioner(StreamPartitioner<T> streamPartitioner) {
        return streamPartitioner;
    }

    @Override
    public OutputTag<T> wrapOutputTag(OutputTag<T> outputTag) {
        return outputTag;
    }

    @Override
    public TypeInformation<T> getWrappedTypeInfo(TypeInformation<T> typeInfo) {
        return typeInfo;
    }
}

