/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.distance;

import org.apache.flink.ml.common.distance.DistanceMeasure;
import org.apache.flink.ml.linalg.VectorWithNorm;
import org.apache.flink.util.Preconditions;

public class ManhattanDistanceMeasure
implements DistanceMeasure {
    private static final ManhattanDistanceMeasure instance = new ManhattanDistanceMeasure();
    public static final String NAME = "manhattan";

    private ManhattanDistanceMeasure() {
    }

    public static ManhattanDistanceMeasure getInstance() {
        return instance;
    }

    @Override
    public double distance(VectorWithNorm v1, VectorWithNorm v2) {
        Preconditions.checkArgument((v1.vector.size() == v2.vector.size() ? 1 : 0) != 0);
        double sum = 0.0;
        for (int i = 0; i < v1.vector.size(); ++i) {
            sum += Math.abs(v1.vector.get(i) - v2.vector.get(i));
        }
        return sum;
    }
}

