/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.iteration;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.iteration.IterationListener;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class TerminateOnMaxIterOrTol
implements IterationListener<Integer>,
FlatMapFunction<Double, Integer> {
    private final int maxIter;
    private final double tol;
    private double loss = Double.MAX_VALUE;

    public TerminateOnMaxIterOrTol(Integer maxIter, Double tol) {
        this.maxIter = maxIter;
        this.tol = tol;
    }

    public TerminateOnMaxIterOrTol(Double tol) {
        this.maxIter = Integer.MAX_VALUE;
        this.tol = tol;
    }

    public void flatMap(Double value, Collector<Integer> out) {
        Preconditions.checkArgument((Double.compare(this.loss, Double.MAX_VALUE) == 0 ? 1 : 0) != 0, (Object)"Each epoch should contain only one loss value.");
        this.loss = value;
    }

    @Override
    public void onEpochWatermarkIncremented(int epochWatermark, IterationListener.Context context, Collector<Integer> collector) {
        if (epochWatermark + 1 < this.maxIter && this.loss > this.tol) {
            collector.collect((Object)0);
        }
        this.loss = Double.MAX_VALUE;
    }

    @Override
    public void onIterationTerminated(IterationListener.Context context, Collector<Integer> collector) {
    }
}

