/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverse;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverses;
import org.apache.flink.statefun.flink.core.backpressure.BackPressureValve;
import org.apache.flink.statefun.flink.core.backpressure.ThresholdBackPressureValve;
import org.apache.flink.statefun.flink.core.common.MailboxExecutorFacade;
import org.apache.flink.statefun.flink.core.common.ManagingResources;
import org.apache.flink.statefun.flink.core.functions.AsyncOperationFailureNotifier;
import org.apache.flink.statefun.flink.core.functions.FlinkTimerServiceFactory;
import org.apache.flink.statefun.flink.core.functions.Reductions;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactory;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.StatefulFunctionProvider;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.OutputTag;

public class FunctionGroupOperator
extends AbstractStreamOperator<Message>
implements OneInputStreamOperator<Message, Message> {
    private static final long serialVersionUID = 1L;
    private final Map<EgressIdentifier<?>, OutputTag<Object>> sideOutputs;
    private final StatefulFunctionsConfig configuration;
    private transient Reductions reductions;
    private transient MailboxExecutor mailboxExecutor;
    private transient BackPressureValve backPressureValve;
    private transient List<ManagingResources> managingResources;

    FunctionGroupOperator(Map<EgressIdentifier<?>, OutputTag<Object>> sideOutputs, StatefulFunctionsConfig configuration, MailboxExecutor mailboxExecutor, ChainingStrategy chainingStrategy, ProcessingTimeService processingTimeService) {
        this.sideOutputs = Objects.requireNonNull(sideOutputs);
        this.configuration = Objects.requireNonNull(configuration);
        this.mailboxExecutor = Objects.requireNonNull(mailboxExecutor);
        this.chainingStrategy = chainingStrategy;
        this.processingTimeService = processingTimeService;
    }

    public void processElement(StreamRecord<Message> record) throws InterruptedException {
        while (this.backPressureValve.shouldBackPressure()) {
            this.mailboxExecutor.yield();
        }
        this.reductions.apply((Message)record.getValue());
    }

    public void open() throws Exception {
        super.open();
        StatefulFunctionsUniverse statefulFunctionsUniverse = this.statefulFunctionsUniverse(this.configuration);
        TypeSerializer envelopeSerializer = this.getOperatorConfig().getTypeSerializerIn(0, this.getContainingTask().getUserCodeClassLoader());
        MapStateDescriptor asyncOperationStateDescriptor = new MapStateDescriptor("asyncOperations", (TypeSerializer)LongSerializer.INSTANCE, envelopeSerializer.duplicate());
        ListStateDescriptor delayedMessageStateDescriptor = new ListStateDescriptor("delayed-messages-buffer", envelopeSerializer.duplicate());
        MapStateDescriptor delayedMessageIndexDescriptor = new MapStateDescriptor("delayed-message-index", String.class, Long.class);
        MapState delayedMessageIndex = this.getRuntimeContext().getMapState(delayedMessageIndexDescriptor);
        MapState asyncOperationState = this.getRuntimeContext().getMapState(asyncOperationStateDescriptor);
        Objects.requireNonNull(this.mailboxExecutor, "MailboxExecutor is unexpectedly NULL");
        this.backPressureValve = new ThresholdBackPressureValve(this.configuration.getMaxAsyncOperationsPerTask());
        this.managingResources = FunctionGroupOperator.resourceManagingFunctionProviders(statefulFunctionsUniverse.functions());
        this.reductions = Reductions.create(this.backPressureValve, statefulFunctionsUniverse, (RuntimeContext)this.getRuntimeContext(), (KeyedStateBackend<Object>)this.getKeyedStateBackend(), new FlinkTimerServiceFactory((InternalTimeServiceManager)super.getTimeServiceManager().orElseThrow(IllegalStateException::new)), this.delayedMessagesBufferState((ListStateDescriptor<Message>)delayedMessageStateDescriptor), (MapState<String, Long>)delayedMessageIndex, this.sideOutputs, (Output<StreamRecord<Message>>)this.output, MessageFactory.forKey(statefulFunctionsUniverse.messageFactoryKey()), new MailboxExecutorFacade(this.mailboxExecutor, "Stateful Functions Mailbox"), this.getRuntimeContext().getMetricGroup().addGroup("functions"), (MapState<Long, Message>)asyncOperationState);
        AsyncOperationFailureNotifier.fireExpiredAsyncOperations((MapStateDescriptor<Long, Message>)asyncOperationStateDescriptor, this.reductions, (KeyedStateBackend<String>)this.getKeyedStateBackend());
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.reductions.snapshotAsyncOperations();
    }

    public void close() throws Exception {
        try {
            this.closeOrDispose();
        }
        finally {
            super.close();
        }
    }

    private void closeOrDispose() {
        List<ManagingResources> managingResources = this.managingResources;
        if (managingResources == null) {
            return;
        }
        for (ManagingResources withResources : managingResources) {
            try {
                withResources.shutdown();
            }
            catch (Throwable t) {
                LOG.warn("Exception caught during close. It would be silently ignored.", t);
            }
        }
    }

    private InternalListState<String, Long, Message> delayedMessagesBufferState(ListStateDescriptor<Message> delayedMessageStateDescriptor) {
        try {
            KeyedStateBackend keyedStateBackend = this.getKeyedStateBackend();
            return (InternalListState)keyedStateBackend.getOrCreateKeyedState((TypeSerializer)LongSerializer.INSTANCE, delayedMessageStateDescriptor);
        }
        catch (Exception e) {
            throw new RuntimeException("Error registered Flink state for delayed messages buffer.", e);
        }
    }

    private StatefulFunctionsUniverse statefulFunctionsUniverse(StatefulFunctionsConfig configuration) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return StatefulFunctionsUniverses.get(classLoader, configuration);
    }

    private static List<ManagingResources> resourceManagingFunctionProviders(Map<FunctionType, StatefulFunctionProvider> functionProviders) {
        return functionProviders.values().stream().filter(provider -> provider instanceof ManagingResources).map(provider -> (ManagingResources)provider).collect(Collectors.toList());
    }
}

