/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.broadcast;

import java.lang.reflect.Field;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.iteration.utils.ReflectionUtils;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.operators.CountingOutput;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;

public class OutputReflectionContext {
    private final Class<?> broadcastingOutputClass;
    private final Field broadcastingOutputsField;
    private final Class<?> chainingOutputClass;
    private final Field chainingOutputTagField;
    private final Field recordWriterField;
    private final Field recordWriterSerializationDelegateField;
    private final Field serializationDelegateSerializerField;
    private final Field countingOutputField;

    public OutputReflectionContext() {
        try {
            this.broadcastingOutputClass = Class.forName("org.apache.flink.streaming.runtime.tasks.BroadcastingOutputCollector");
            this.broadcastingOutputsField = ReflectionUtils.getClassField(this.broadcastingOutputClass, "outputs");
            this.chainingOutputClass = Class.forName("org.apache.flink.streaming.runtime.tasks.ChainingOutput");
            this.chainingOutputTagField = ReflectionUtils.getClassField(this.chainingOutputClass, "outputTag");
            this.recordWriterField = ReflectionUtils.getClassField(RecordWriterOutput.class, "recordWriter");
            this.recordWriterSerializationDelegateField = ReflectionUtils.getClassField(RecordWriterOutput.class, "serializationDelegate");
            this.serializationDelegateSerializerField = ReflectionUtils.getClassField(SerializationDelegate.class, "serializer");
            this.countingOutputField = ReflectionUtils.getClassField(CountingOutput.class, "output");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize the OutputReflectionContext", e);
        }
    }

    public boolean isBroadcastingOutput(Output<?> rawOutput) {
        return this.broadcastingOutputClass.isAssignableFrom(rawOutput.getClass());
    }

    public boolean isChainingOutput(Output<?> rawOutput) {
        return this.chainingOutputClass.isAssignableFrom(rawOutput.getClass());
    }

    public boolean isRecordWriterOutput(Output<?> rawOutput) {
        return RecordWriterOutput.class.isAssignableFrom(rawOutput.getClass());
    }

    public boolean isCountingOutput(Output<?> rawOutput) {
        return CountingOutput.class.isAssignableFrom(rawOutput.getClass());
    }

    public <OUT> Output<StreamRecord<OUT>>[] getBroadcastingInternalOutputs(Object output) {
        return (Output[])ReflectionUtils.getFieldValue(output, this.broadcastingOutputsField);
    }

    public <OUT> Output<StreamRecord<OUT>> getCountingInternalOutput(Object output) {
        return (Output)ReflectionUtils.getFieldValue(output, this.countingOutputField);
    }

    public OutputTag<?> getChainingOutputTag(Object output) {
        return (OutputTag)ReflectionUtils.getFieldValue(output, this.chainingOutputTagField);
    }

    public RecordWriter<SerializationDelegate<StreamElement>> getRecordWriter(Object output) {
        return (RecordWriter)ReflectionUtils.getFieldValue(output, this.recordWriterField);
    }

    public TypeSerializer<StreamElement> getRecordWriterTypeSerializer(Object output) {
        SerializationDelegate serializationDelegate = (SerializationDelegate)ReflectionUtils.getFieldValue(output, this.recordWriterSerializationDelegateField);
        TypeSerializer typeSerializer = (TypeSerializer)ReflectionUtils.getFieldValue(serializationDelegate, this.serializationDelegateSerializerField);
        return typeSerializer.duplicate();
    }
}

