/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.progresstrack;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.flink.iteration.progresstrack.OperatorEpochWatermarkTracker;
import org.apache.flink.iteration.progresstrack.OperatorEpochWatermarkTrackerListener;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

public class OperatorEpochWatermarkTrackerFactory {
    public static OperatorEpochWatermarkTracker create(StreamConfig streamConfig, StreamTask<?, ?> containingTask, OperatorEpochWatermarkTrackerListener progressTrackerListener) {
        int[] numberOfChannels;
        if (!streamConfig.isChainStart()) {
            numberOfChannels = new int[]{1};
        } else {
            IndexedInputGate[] inputGates = containingTask.getEnvironment().getAllInputGates();
            List inEdges = streamConfig.getInPhysicalEdges(containingTask.getUserCodeClassLoader());
            TreeSet edgeTypes = new TreeSet();
            inEdges.forEach(edge -> edgeTypes.add(edge.getTypeNumber()));
            HashMap<Integer, Integer> edgeTypeToIndices = new HashMap<Integer, Integer>();
            Iterator iterator = edgeTypes.iterator();
            while (iterator.hasNext()) {
                int edgeType = (Integer)iterator.next();
                edgeTypeToIndices.put(edgeType, edgeTypeToIndices.size());
            }
            numberOfChannels = new int[edgeTypeToIndices.size()];
            for (int i = 0; i < inEdges.size(); ++i) {
                int n = (Integer)edgeTypeToIndices.get(((StreamEdge)inEdges.get(i)).getTypeNumber());
                numberOfChannels[n] = numberOfChannels[n] + inputGates[i].getNumberOfInputChannels();
            }
        }
        return new OperatorEpochWatermarkTracker(numberOfChannels, progressTrackerListener);
    }
}

