/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.proxy;

import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.typeinfo.IterationRecordSerializer;
import org.apache.flink.iteration.utils.ReflectionUtils;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.ConfigurableStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class ProxyStreamPartitioner<T>
extends StreamPartitioner<IterationRecord<T>>
implements ConfigurableStreamPartitioner {
    private final StreamPartitioner<T> wrappedStreamPartitioner;
    private transient SerializationDelegate<StreamRecord<T>> reuseDelegate;
    private transient StreamRecord<T> reuseRecord;

    public ProxyStreamPartitioner(StreamPartitioner<T> wrappedStreamPartitioner) {
        this.wrappedStreamPartitioner = Objects.requireNonNull(wrappedStreamPartitioner);
    }

    public void setup(int numberOfChannels) {
        super.setup(numberOfChannels);
        this.wrappedStreamPartitioner.setup(numberOfChannels);
    }

    public StreamPartitioner<IterationRecord<T>> copy() {
        return new ProxyStreamPartitioner<T>(this.wrappedStreamPartitioner.copy());
    }

    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return this.wrappedStreamPartitioner.getDownstreamSubtaskStateMapper();
    }

    public boolean isPointwise() {
        return this.wrappedStreamPartitioner.isPointwise();
    }

    public int selectChannel(SerializationDelegate<StreamRecord<IterationRecord<T>>> record) {
        if (this.reuseDelegate != null) {
            this.reuseDelegate.setInstance((Object)this.reuseRecord.replace(((IterationRecord)((StreamRecord)record.getInstance()).getValue()).getValue(), ((StreamRecord)record.getInstance()).getTimestamp()));
            return this.wrappedStreamPartitioner.selectChannel(this.reuseDelegate);
        }
        this.reuseRecord = new StreamRecord(null, 0L);
        StreamElementSerializer streamElementSerializer = (StreamElementSerializer)ReflectionUtils.getFieldValue(record, SerializationDelegate.class, "serializer");
        IterationRecordSerializer iterationRecordSerializer = (IterationRecordSerializer)streamElementSerializer.getContainedTypeSerializer();
        this.reuseDelegate = new SerializationDelegate((TypeSerializer)new StreamElementSerializer(iterationRecordSerializer.getInnerSerializer().duplicate()));
        return this.selectChannel(record);
    }

    public String toString() {
        return this.wrappedStreamPartitioner.toString();
    }

    public void configure(int maxParallelism) {
        if (this.wrappedStreamPartitioner instanceof ConfigurableStreamPartitioner) {
            ((ConfigurableStreamPartitioner)this.wrappedStreamPartitioner).configure(maxParallelism);
        }
    }
}

