/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.distance;

import org.apache.flink.ml.common.distance.DistanceMeasure;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.VectorWithNorm;

public class EuclideanDistanceMeasure
implements DistanceMeasure {
    private static final EuclideanDistanceMeasure instance = new EuclideanDistanceMeasure();
    public static final String NAME = "euclidean";

    private EuclideanDistanceMeasure() {
    }

    public static EuclideanDistanceMeasure getInstance() {
        return instance;
    }

    @Override
    public double distance(VectorWithNorm v1, VectorWithNorm v2) {
        return Math.sqrt(this.distanceSquare(v1, v2));
    }

    private double distanceSquare(VectorWithNorm v1, VectorWithNorm v2) {
        return Math.max(0.0, v1.l2Norm * v1.l2Norm + v2.l2Norm * v2.l2Norm - 2.0 * BLAS.dot(v1.vector, v2.vector));
    }

    @Override
    public int findClosest(VectorWithNorm[] centroids, VectorWithNorm point) {
        double bestL2DistanceSquare = Double.POSITIVE_INFINITY;
        int bestIndex = 0;
        for (int i = 0; i < centroids.length; ++i) {
            double l2DistanceSquare;
            VectorWithNorm centroid = centroids[i];
            double lowerBoundSqrt = point.l2Norm - centroid.l2Norm;
            double lowerBound = lowerBoundSqrt * lowerBoundSqrt;
            if (lowerBound >= bestL2DistanceSquare || !((l2DistanceSquare = this.distanceSquare(point, centroid)) < bestL2DistanceSquare)) continue;
            bestL2DistanceSquare = l2DistanceSquare;
            bestIndex = i;
        }
        return bestIndex;
    }
}

