/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.tokenizer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.feature.tokenizer.TokenizerParams;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.util.Preconditions;

public class Tokenizer
implements Transformer<Tokenizer>,
TokenizerParams<Tokenizer> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public Tokenizer() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        Expression tokenizerUdf = (Expression)Expressions.call(TokenizerUdf.class, (Object[])new Object[]{Expressions.$((String)this.getInputCol())}).as(this.getOutputCol(), new String[0]);
        Table output = inputs[0].addColumns(new Expression[]{tokenizerUdf});
        return new Table[]{output};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public static Tokenizer load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (Tokenizer)ReadWriteUtils.loadStageParam(path);
    }

    public static class TokenizerUdf
    extends ScalarFunction {
        public String[] eval(String input) {
            return input.toLowerCase().split("\\s");
        }
    }
}

