/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.manifest;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.manifest.ManifestFileMeta;
import org.apache.flink.table.store.file.manifest.ManifestFileMetaSerializer;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.VersionedObjectSerializer;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.types.logical.RowType;

public class ManifestList {
    private final ManifestFileMetaSerializer serializer;
    private final BulkFormat<RowData, FileSourceSplit> readerFactory;
    private final BulkWriter.Factory<RowData> writerFactory;
    private final FileStorePathFactory pathFactory;

    private ManifestList(ManifestFileMetaSerializer serializer, BulkFormat<RowData, FileSourceSplit> readerFactory, BulkWriter.Factory<RowData> writerFactory, FileStorePathFactory pathFactory) {
        this.serializer = serializer;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.pathFactory = pathFactory;
    }

    public List<ManifestFileMeta> read(String fileName) {
        try {
            return FileUtils.readListFromFile(this.pathFactory.toManifestListPath(fileName), this.serializer, this.readerFactory);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read manifest list " + fileName, e);
        }
    }

    public String write(List<ManifestFileMeta> metas) {
        Path path = this.pathFactory.newManifestList();
        try {
            return this.write(metas, path);
        }
        catch (Throwable e) {
            FileUtils.deleteOrWarn(path);
            throw new RuntimeException("Exception occurs when writing manifest list " + path + ". Clean up.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String write(List<ManifestFileMeta> metas, Path path) throws IOException {
        FileSystem fs = path.getFileSystem();
        try (FSDataOutputStream out = fs.create(path, FileSystem.WriteMode.NO_OVERWRITE);){
            BulkWriter writer = this.writerFactory.create(out);
            try {
                for (ManifestFileMeta manifest : metas) {
                    writer.addElement((Object)this.serializer.toRow(manifest));
                }
            }
            finally {
                writer.flush();
                writer.finish();
            }
        }
        return path.getName();
    }

    public void delete(String fileName) {
        FileUtils.deleteOrWarn(this.pathFactory.toManifestListPath(fileName));
    }

    public static class Factory {
        private final RowType partitionType;
        private final FileFormat fileFormat;
        private final FileStorePathFactory pathFactory;

        public Factory(RowType partitionType, FileFormat fileFormat, FileStorePathFactory pathFactory) {
            this.partitionType = partitionType;
            this.fileFormat = fileFormat;
            this.pathFactory = pathFactory;
        }

        public ManifestList create() {
            RowType metaType = VersionedObjectSerializer.versionType(ManifestFileMeta.schema());
            return new ManifestList(new ManifestFileMetaSerializer(), this.fileFormat.createReaderFactory(metaType), this.fileFormat.createWriterFactory(metaType), this.pathFactory);
        }
    }
}

