/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.avro;

import java.io.IOException;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.reflect.ReflectData;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.specific.SpecificData;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.ParquetBuilder;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.ParquetWriterFactory;
import org.apache.flink.table.store.shaded.org.apache.parquet.avro.AvroParquetWriter;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.OutputFile;

@Experimental
public class AvroParquetWriters {
    public static <T extends SpecificRecordBase> ParquetWriterFactory<T> forSpecificRecord(Class<T> type) {
        String schemaString = SpecificData.get().getSchema(type).toString();
        ParquetBuilder builder = out -> AvroParquetWriters.createAvroParquetWriter(schemaString, SpecificData.get(), out);
        return new ParquetWriterFactory(builder);
    }

    public static ParquetWriterFactory<GenericRecord> forGenericRecord(Schema schema) {
        String schemaString = schema.toString();
        ParquetBuilder builder = out -> AvroParquetWriters.createAvroParquetWriter(schemaString, GenericData.get(), out);
        return new ParquetWriterFactory<GenericRecord>(builder);
    }

    public static <T> ParquetWriterFactory<T> forReflectRecord(Class<T> type) {
        String schemaString = ReflectData.get().getSchema(type).toString();
        ParquetBuilder builder = out -> AvroParquetWriters.createAvroParquetWriter(schemaString, ReflectData.get(), out);
        return new ParquetWriterFactory(builder);
    }

    private static <T> ParquetWriter<T> createAvroParquetWriter(String schemaString, GenericData dataModel, OutputFile out) throws IOException {
        Schema schema = new Schema.Parser().parse(schemaString);
        return AvroParquetWriter.builder((OutputFile)out).withSchema(schema).withDataModel(dataModel).build();
    }

    private AvroParquetWriters() {
    }
}

