/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.streaming.connectors.kafka.table;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.shaded.streaming.connectors.kafka.table.ReducingUpsertWriter;
import org.apache.flink.table.store.shaded.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.function.SerializableFunction;

class ReducingUpsertSink<WriterState>
implements StatefulSink<RowData, WriterState> {
    private final StatefulSink<RowData, WriterState> wrappedSink;
    private final DataType physicalDataType;
    private final int[] keyProjection;
    private final SinkBufferFlushMode bufferFlushMode;
    private final SerializableFunction<RowData, RowData> valueCopyFunction;

    ReducingUpsertSink(StatefulSink<RowData, WriterState> wrappedSink, DataType physicalDataType, int[] keyProjection, SinkBufferFlushMode bufferFlushMode, SerializableFunction<RowData, RowData> valueCopyFunction) {
        this.wrappedSink = wrappedSink;
        this.physicalDataType = physicalDataType;
        this.keyProjection = keyProjection;
        this.bufferFlushMode = bufferFlushMode;
        this.valueCopyFunction = valueCopyFunction;
    }

    public StatefulSink.StatefulSinkWriter<RowData, WriterState> createWriter(Sink.InitContext context) throws IOException {
        StatefulSink.StatefulSinkWriter wrapperWriter = this.wrappedSink.createWriter(context);
        return new ReducingUpsertWriter(wrapperWriter, this.physicalDataType, this.keyProjection, this.bufferFlushMode, context.getProcessingTimeService(), (Function<RowData, RowData>)this.valueCopyFunction);
    }

    public StatefulSink.StatefulSinkWriter<RowData, WriterState> restoreWriter(Sink.InitContext context, Collection<WriterState> recoveredState) throws IOException {
        StatefulSink.StatefulSinkWriter wrapperWriter = this.wrappedSink.restoreWriter(context, recoveredState);
        return new ReducingUpsertWriter(wrapperWriter, this.physicalDataType, this.keyProjection, this.bufferFlushMode, context.getProcessingTimeService(), (Function<RowData, RowData>)this.valueCopyFunction);
    }

    public SimpleVersionedSerializer<WriterState> getWriterStateSerializer() {
        return this.wrappedSink.getWriterStateSerializer();
    }
}

