/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkChecker;
import org.apache.flink.runtime.scheduler.DefaultSyncPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocationContext;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocator;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.LocalInputPreferredSlotSharingStrategy;
import org.apache.flink.runtime.scheduler.MergingSharedSlotProfileRetrieverFactory;
import org.apache.flink.runtime.scheduler.SlotSharingExecutionSlotAllocator;
import org.apache.flink.runtime.scheduler.SlotSharingStrategy;

public class SlotSharingExecutionSlotAllocatorFactory
implements ExecutionSlotAllocatorFactory {
    private final PhysicalSlotProvider slotProvider;
    private final boolean slotWillBeOccupiedIndefinitely;
    private final PhysicalSlotRequestBulkChecker bulkChecker;
    private final Time allocationTimeout;
    private final SlotSharingStrategy.Factory slotSharingStrategyFactory;

    public SlotSharingExecutionSlotAllocatorFactory(PhysicalSlotProvider slotProvider, boolean slotWillBeOccupiedIndefinitely, PhysicalSlotRequestBulkChecker bulkChecker, Time allocationTimeout) {
        this(slotProvider, slotWillBeOccupiedIndefinitely, bulkChecker, allocationTimeout, new LocalInputPreferredSlotSharingStrategy.Factory());
    }

    SlotSharingExecutionSlotAllocatorFactory(PhysicalSlotProvider slotProvider, boolean slotWillBeOccupiedIndefinitely, PhysicalSlotRequestBulkChecker bulkChecker, Time allocationTimeout, SlotSharingStrategy.Factory slotSharingStrategyFactory) {
        this.slotProvider = slotProvider;
        this.slotWillBeOccupiedIndefinitely = slotWillBeOccupiedIndefinitely;
        this.bulkChecker = bulkChecker;
        this.slotSharingStrategyFactory = slotSharingStrategyFactory;
        this.allocationTimeout = allocationTimeout;
    }

    @Override
    public ExecutionSlotAllocator createInstance(ExecutionSlotAllocationContext context) {
        SlotSharingStrategy slotSharingStrategy = this.slotSharingStrategyFactory.create(context.getSchedulingTopology(), context.getLogicalSlotSharingGroups(), context.getCoLocationGroups());
        DefaultSyncPreferredLocationsRetriever preferredLocationsRetriever = new DefaultSyncPreferredLocationsRetriever(context, context);
        MergingSharedSlotProfileRetrieverFactory sharedSlotProfileRetrieverFactory = new MergingSharedSlotProfileRetrieverFactory(preferredLocationsRetriever, context::findPriorAllocationId, context::getReservedAllocations);
        return new SlotSharingExecutionSlotAllocator(this.slotProvider, this.slotWillBeOccupiedIndefinitely, slotSharingStrategy, sharedSlotProfileRetrieverFactory, this.bulkChecker, this.allocationTimeout, context::getResourceProfile);
    }
}

