/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;

@Internal
public class TwoInputTransformation<IN1, IN2, OUT>
extends PhysicalTransformation<OUT> {
    private final Transformation<IN1> input1;
    private final Transformation<IN2> input2;
    private final StreamOperatorFactory<OUT> operatorFactory;
    private KeySelector<IN1, ?> stateKeySelector1;
    private KeySelector<IN2, ?> stateKeySelector2;
    private TypeInformation<?> stateKeyType;

    public TwoInputTransformation(Transformation<IN1> input1, Transformation<IN2> input2, String name, TwoInputStreamOperator<IN1, IN2, OUT> operator, TypeInformation<OUT> outputType, int parallelism) {
        this(input1, input2, name, SimpleOperatorFactory.of(operator), outputType, parallelism);
    }

    public TwoInputTransformation(Transformation<IN1> input1, Transformation<IN2> input2, String name, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<OUT> outputType, int parallelism) {
        super(name, outputType, parallelism);
        this.input1 = input1;
        this.input2 = input2;
        this.operatorFactory = operatorFactory;
    }

    public Transformation<IN1> getInput1() {
        return this.input1;
    }

    public Transformation<IN2> getInput2() {
        return this.input2;
    }

    @Override
    public List<Transformation<?>> getInputs() {
        ArrayList inputs = new ArrayList();
        inputs.add(this.input1);
        inputs.add(this.input2);
        return inputs;
    }

    public TypeInformation<IN1> getInputType1() {
        return this.input1.getOutputType();
    }

    public TypeInformation<IN2> getInputType2() {
        return this.input2.getOutputType();
    }

    @VisibleForTesting
    public TwoInputStreamOperator<IN1, IN2, OUT> getOperator() {
        return (TwoInputStreamOperator)((SimpleOperatorFactory)this.operatorFactory).getOperator();
    }

    public StreamOperatorFactory<OUT> getOperatorFactory() {
        return this.operatorFactory;
    }

    public void setStateKeySelectors(KeySelector<IN1, ?> stateKeySelector1, KeySelector<IN2, ?> stateKeySelector2) {
        this.stateKeySelector1 = stateKeySelector1;
        this.stateKeySelector2 = stateKeySelector2;
        this.updateManagedMemoryStateBackendUseCase(stateKeySelector1 != null || stateKeySelector2 != null);
    }

    public KeySelector<IN1, ?> getStateKeySelector1() {
        return this.stateKeySelector1;
    }

    public KeySelector<IN2, ?> getStateKeySelector2() {
        return this.stateKeySelector2;
    }

    public void setStateKeyType(TypeInformation<?> stateKeyType) {
        this.stateKeyType = stateKeyType;
    }

    public TypeInformation<?> getStateKeyType() {
        return this.stateKeyType;
    }

    @Override
    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList<Transformation<?>> result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input1.getTransitivePredecessors());
        result.addAll(this.input2.getTransitivePredecessors());
        return result;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operatorFactory.setChainingStrategy(strategy);
    }
}

