/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.geode.internal.offheap;


/**
 * Basic size and usage information about an off-heap memory block under inspection. For test
 * validation only.
 *
 * @since Geode 1.0
 */
public interface MemoryBlock {

  enum State {
    /** Unused fragment (not used and not in a free list) */
    UNUSED,
    /** Allocated chunk currently in use */
    ALLOCATED,
    /** Deallocated chunk currently in a free list */
    DEALLOCATED
  }

  State getState();

  /**
   * Returns the unsafe memory address of the first byte of this block.
   */
  long getAddress();

  /**
   * Returns the size of this memory block in bytes.
   */
  int getBlockSize();

  /**
   * Returns the next memory block immediately after this one.
   */
  MemoryBlock getNextBlock();

  /**
   * Returns the identifier of which slab contains this block.
   */
  int getSlabId();

  /**
   * Returns the identifier of which free list contains this block.
   */
  int getFreeListId();

  int getRefCount();

  String getDataType();

  boolean isSerialized();

  boolean isCompressed();

  Object getDataValue();
}
