/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.geo;

import java.util.HashMap;

public final class Base32 {
    private static final char[] characters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final HashMap<Character, Integer> characterIndexes = new HashMap();

    private Base32() {
    }

    public static String encodeBase32(long i, int length) {
        boolean negative;
        char[] buf = new char[65];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= -32L) {
            buf[charPos--] = characters[(int)(-(i % 32L))];
            i /= 32L;
        }
        buf[charPos] = characters[(int)(-i)];
        String result = Base32.padLeftWithZerosToLength(new String(buf, charPos, 65 - charPos), length);
        if (negative) {
            return "-" + result;
        }
        return result;
    }

    public static String encodeBase32(long i) {
        return Base32.encodeBase32(i, 12);
    }

    public static long decodeBase32(String hash) {
        boolean isNegative = hash.startsWith("-");
        int startIndex = isNegative ? 1 : 0;
        long base = 1L;
        long result = 0L;
        for (int i = hash.length() - 1; i >= startIndex; --i) {
            int j = Base32.getCharIndex(hash.charAt(i));
            result += base * (long)j;
            base *= 32L;
        }
        if (isNegative) {
            result *= -1L;
        }
        return result;
    }

    static int getCharIndex(char ch) {
        Integer result = characterIndexes.get(Character.valueOf(ch));
        if (result == null) {
            throw new IllegalArgumentException("not a base32 character: " + ch);
        }
        return result;
    }

    static String padLeftWithZerosToLength(String s, int length) {
        if (s.length() < length) {
            int count = length - s.length();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                b.append('0');
            }
            b.append(s);
            return b.toString();
        }
        return s;
    }

    static {
        int i = 0;
        for (char c : characters) {
            characterIndexes.put(Character.valueOf(c), i++);
        }
    }
}

