/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.internal.QueryConfigurationService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class AlterQueryServiceFunction
extends CliFunction<Object[]> {
    private static final long serialVersionUID = 7155576168386556341L;
    public static final String AUTHORIZER_UPDATED_MESSAGE = "Updated MethodInvocationAuthorizer. New authorizer is: ";
    static final String AUTHORIZER_PARAMETERS_MESSAGE = " with parameters: ";
    public static final String EMPTY_AUTHORIZER_ERROR = "MethodInvocationAuthorizer class name must not be empty.";
    public static final String SECURITY_NOT_ENABLED_MESSAGE = "Integrated security is not enabled for this distributed system. Updating the method authorizer requires integrated security to be enabled.";
    public static final String DEPRECATED_PROPERTY_ERROR = "Deprecated System Property: \"gemfire.QueryService.allowUntrustedMethodInvocation\" is set to TRUE. In order to use a MethodInvocationAuthorizer, this property must be FALSE or undefined.";

    boolean isSecurityEnabled() {
        return ((InternalCache)CacheFactory.getAnyInstance()).getSecurityService().isIntegratedSecurity();
    }

    @Override
    public CliFunctionResult executeFunction(FunctionContext<Object[]> context) {
        boolean forceUpdate = (Boolean)((Object[])context.getArguments())[0];
        String authorizerName = (String)((Object[])context.getArguments())[1];
        Set parameterSet = ((Object[])context.getArguments())[2] != null ? (Set)((Object[])context.getArguments())[2] : Collections.emptySet();
        if (StringUtils.isEmpty((CharSequence)authorizerName)) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, EMPTY_AUTHORIZER_ERROR);
        }
        if (!this.isSecurityEnabled()) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, SECURITY_NOT_ENABLED_MESSAGE);
        }
        if (Boolean.parseBoolean(System.getProperty("gemfire.QueryService.allowUntrustedMethodInvocation"))) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, DEPRECATED_PROPERTY_ERROR);
        }
        try {
            Cache cache = context.getCache();
            ((QueryConfigurationService)((InternalCache)cache).getService(QueryConfigurationService.class)).updateMethodAuthorizer(cache, forceUpdate, authorizerName, parameterSet);
        }
        catch (Exception ex) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, ex.getMessage());
        }
        String message = AUTHORIZER_UPDATED_MESSAGE + authorizerName + (parameterSet.size() > 0 ? AUTHORIZER_PARAMETERS_MESSAGE + String.join((CharSequence)", ", parameterSet) : "");
        return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, message);
    }
}

