/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.parallel;

import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderEventRemoteDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.parallel.RemoteParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;

public class RemoteConcurrentParallelGatewaySenderEventProcessor
extends ConcurrentParallelGatewaySenderEventProcessor {
    public RemoteConcurrentParallelGatewaySenderEventProcessor(AbstractGatewaySender sender, ThreadsMonitoring tMonitoring) {
        super(sender, tMonitoring);
    }

    @Override
    protected void createProcessors(int dispatcherThreads, Set<Region> targetRs) {
        this.processors = new RemoteParallelGatewaySenderEventProcessor[this.sender.getDispatcherThreads()];
        if (logger.isDebugEnabled()) {
            logger.debug("Creating GatewaySenderEventProcessor");
        }
        for (int i = 0; i < this.sender.getDispatcherThreads(); ++i) {
            this.processors[i] = new RemoteParallelGatewaySenderEventProcessor(this.sender, targetRs, i, this.sender.getDispatcherThreads(), this.getThreadMonitorObj());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rebalance() {
        GatewaySenderStats statistics = this.sender.getStatistics();
        long startTime = statistics.startLoadBalance();
        try {
            for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
                GatewaySenderEventRemoteDispatcher remoteDispatcher = (GatewaySenderEventRemoteDispatcher)parallelProcessor.getDispatcher();
                if (!remoteDispatcher.isConnectedToRemote()) continue;
                remoteDispatcher.stopAckReaderThread();
                remoteDispatcher.destroyConnection();
            }
        }
        finally {
            statistics.endLoadBalance(startTime);
        }
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.sender.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }
}

