/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hash.RedisHash;

class GeodeRedisHashSynchronized
implements RedisHash {
    private final ByteArrayWrapper key;
    private final ExecutionHandlerContext context;

    public GeodeRedisHashSynchronized(ByteArrayWrapper key, ExecutionHandlerContext context) {
        this.key = key;
        this.context = context;
    }

    @Override
    public int hset(List<ByteArrayWrapper> fieldsToSet, boolean NX) {
        AtomicInteger fieldsAdded = new AtomicInteger();
        Map computedHash = (Map)this.region().compute((Object)this.key, (_unused_, oldHash) -> {
            fieldsAdded.set(0);
            HashMap<ByteArrayWrapper, ByteArrayWrapper> newHash = oldHash == null ? new HashMap<ByteArrayWrapper, ByteArrayWrapper>() : new HashMap(oldHash);
            for (int i = 0; i < fieldsToSet.size(); i += 2) {
                ByteArrayWrapper field = (ByteArrayWrapper)fieldsToSet.get(i);
                ByteArrayWrapper value = (ByteArrayWrapper)fieldsToSet.get(i + 1);
                if (NX) {
                    newHash.putIfAbsent(field, value);
                    continue;
                }
                newHash.put(field, value);
            }
            if (oldHash == null) {
                fieldsAdded.set(newHash.size());
            } else {
                fieldsAdded.set(newHash.size() - oldHash.size());
            }
            return newHash;
        });
        if (computedHash != null) {
            this.context.getKeyRegistrar().register(this.key, RedisDataType.REDIS_HASH);
        }
        return fieldsAdded.get();
    }

    @Override
    public int hdel(List<ByteArrayWrapper> subList) {
        RedisDataType type;
        AtomicLong numDeleted = new AtomicLong();
        this.region().computeIfPresent((Object)this.key, (_unused_, oldHash) -> {
            HashMap newHash = new HashMap(oldHash);
            for (ByteArrayWrapper fieldToRemove : subList) {
                newHash.remove(fieldToRemove);
            }
            numDeleted.set(oldHash.size() - newHash.size());
            return newHash;
        });
        if (this.hgetall().isEmpty() && (type = this.context.getKeyRegistrar().getType(this.key)) == RedisDataType.REDIS_HASH) {
            this.context.getRegionProvider().removeKey(this.key, type);
        }
        return numDeleted.intValue();
    }

    @Override
    public Collection<Map.Entry<ByteArrayWrapper, ByteArrayWrapper>> hgetall() {
        return ((Map)this.region().getOrDefault((Object)this.key, Collections.emptyMap())).entrySet();
    }

    private Region<ByteArrayWrapper, Map<ByteArrayWrapper, ByteArrayWrapper>> region() {
        return this.context.getRegionProvider().getHashRegion();
    }
}

