/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HValsExecutor
extends HashExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HVALS command is \"HVALS key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_HASH, context);
        Map map = (Map)context.getRegionProvider().getHashRegion().get((Object)key);
        if (map == null) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        ArrayList vals = new ArrayList(map.values());
        if (vals.isEmpty()) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        this.respondBulkStrings(command, context, vals);
    }
}

