/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.set.DeltaSet;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SIsMemberExecutor
extends SetExecutor {
    private static final int EXISTS = 1;
    private static final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() != 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SISMEMBER command is \"SISMEMBER key member\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        if (!context.getKeyRegistrar().isRegistered(key)) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        ByteArrayWrapper member = new ByteArrayWrapper(commandElems.get(2));
        Region<ByteArrayWrapper, DeltaSet> region = this.getRegion(context);
        DeltaSet set = (DeltaSet)region.get((Object)key);
        if (set == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        if (set.contains(member)) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
            context.getKeyRegistrar().register(key, RedisDataType.REDIS_SET);
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }
}

