/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.set.GeodeRedisSetWithFunctions;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SRemExecutor
extends SetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<ByteArrayWrapper> commandElements = command.getProcessedCommandWrappers();
        if (commandElements.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SREM command is \"SREM key member [member ...]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SET, context);
        GeodeRedisSetWithFunctions geodeRedisSet = new GeodeRedisSetWithFunctions(key, context.getRegionProvider().getSetRegion());
        ArrayList<ByteArrayWrapper> membersToRemove = new ArrayList<ByteArrayWrapper>(commandElements.subList(2, commandElements.size()));
        AtomicBoolean setWasDeleted = new AtomicBoolean();
        long membersRemoved = geodeRedisSet.srem(membersToRemove, setWasDeleted);
        if (setWasDeleted.get()) {
            context.getKeyRegistrar().unregisterIfType(key, RedisDataType.REDIS_SET);
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), membersRemoved));
    }
}

