/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.HashMap;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RedisDataTypeMismatchException;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class MSetNXExecutor
extends StringExecutor {
    private final int SET = 1;
    private final int NOT_SET = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> region = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3 || commandElems.size() % 2 == 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the MSETNX command is \"MSETNX key value [key value ...]\", or not every key matches a value"));
            return;
        }
        boolean hasEntry = false;
        HashMap<ByteArrayWrapper, ByteArrayWrapper> map = new HashMap<ByteArrayWrapper, ByteArrayWrapper>();
        for (int i = 1; i < commandElems.size(); i += 2) {
            byte[] keyArray = commandElems.get(i);
            ByteArrayWrapper key = new ByteArrayWrapper(keyArray);
            try {
                this.checkDataType(key, RedisDataType.REDIS_STRING, context);
            }
            catch (RedisDataTypeMismatchException e) {
                hasEntry = true;
                break;
            }
            byte[] value = commandElems.get(i + 1);
            map.put(key, new ByteArrayWrapper(value));
            if (!region.containsKey((Object)key)) continue;
            hasEntry = true;
            break;
        }
        boolean successful = false;
        if (!hasEntry) {
            successful = true;
            for (ByteArrayWrapper k : map.keySet()) {
                try {
                    this.checkAndSetDataType(k, context);
                }
                catch (RedisDataTypeMismatchException e) {
                    successful = false;
                    break;
                }
            }
            region.putAll(map);
        }
        if (successful) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }
}

