/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.security;

import java.util.Set;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.cache.client.internal.locator.ClientConnectionResponse;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.protocol.protobuf.security.SecureLocator;
import org.apache.geode.internal.protocol.protobuf.security.Security;
import org.apache.geode.security.ResourcePermission;

public class SecureLocatorImpl
implements SecureLocator {
    private final Locator locator;
    private final Security security;

    public SecureLocatorImpl(Locator locator, Security security) {
        this.locator = locator;
        this.security = security;
    }

    @Override
    public ServerLocation findServer(Set<ServerLocation> excludedServers, String serverGroup) {
        this.security.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, "*", "*");
        InternalLocator internalLocator = (InternalLocator)this.locator;
        ClientConnectionRequest clientConnectionRequest = new ClientConnectionRequest(excludedServers, serverGroup);
        ClientConnectionResponse connectionResponse = (ClientConnectionResponse)internalLocator.getServerLocatorAdvisee().processRequest(clientConnectionRequest);
        ServerLocation serverLocation = null;
        if (connectionResponse != null && connectionResponse.hasResult()) {
            serverLocation = connectionResponse.getServer();
        }
        return serverLocation;
    }
}

